/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gts;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.sis.internal.geoapi.temporal.TemporalFactory;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.internal.xml.XmlUtilities;
import org.apache.sis.util.SimpleInternationalString;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

public class TM_PeriodDuration
extends PropertyType<TM_PeriodDuration, PeriodDuration> {
    TM_PeriodDuration() {
    }

    private TM_PeriodDuration(PeriodDuration periodDuration) {
        super(periodDuration);
    }

    @Override
    protected TM_PeriodDuration wrap(PeriodDuration periodDuration) {
        return new TM_PeriodDuration(periodDuration);
    }

    @Override
    protected final Class<PeriodDuration> getBoundType() {
        return PeriodDuration.class;
    }

    @XmlElement(name="TM_PeriodDuration")
    public final Duration getElement() {
        return TM_PeriodDuration.toXML((PeriodDuration)this.metadata);
    }

    static Duration toXML(PeriodDuration periodDuration) {
        if (periodDuration instanceof org.apache.sis.internal.geoapi.temporal.PeriodDuration) {
            try {
                org.apache.sis.internal.geoapi.temporal.PeriodDuration periodDuration2 = (org.apache.sis.internal.geoapi.temporal.PeriodDuration)periodDuration;
                DatatypeFactory datatypeFactory = XmlUtilities.getDatatypeFactory();
                BigInteger bigInteger = null;
                InternationalString internationalString = periodDuration2.getYears();
                if (internationalString != null) {
                    bigInteger = new BigInteger(internationalString.toString());
                }
                BigInteger bigInteger2 = null;
                internationalString = periodDuration2.getMonths();
                if (internationalString != null) {
                    bigInteger2 = new BigInteger(internationalString.toString());
                }
                BigInteger bigInteger3 = null;
                internationalString = periodDuration2.getDays();
                if (internationalString != null) {
                    bigInteger3 = new BigInteger(internationalString.toString());
                }
                BigInteger bigInteger4 = null;
                internationalString = periodDuration2.getHours();
                if (internationalString != null) {
                    bigInteger4 = new BigInteger(internationalString.toString());
                }
                BigInteger bigInteger5 = null;
                internationalString = periodDuration2.getMinutes();
                if (internationalString != null) {
                    bigInteger5 = new BigInteger(internationalString.toString());
                }
                BigDecimal bigDecimal = null;
                internationalString = periodDuration2.getSeconds();
                if (internationalString != null) {
                    bigDecimal = new BigDecimal(internationalString.toString());
                }
                return datatypeFactory.newDuration(true, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigDecimal);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                TM_PeriodDuration.warningOccured("toXML", datatypeConfigurationException);
            }
        }
        return null;
    }

    public final void setElement(Duration duration) {
        this.metadata = TM_PeriodDuration.toISO(duration);
    }

    static PeriodDuration toISO(Duration duration) {
        if (duration != null) {
            try {
                TemporalFactory temporalFactory = TemporalUtilities.getTemporalFactory();
                SimpleInternationalString simpleInternationalString = null;
                int n = duration.getYears();
                if (n != 0) {
                    simpleInternationalString = new SimpleInternationalString(Integer.toString(n));
                }
                SimpleInternationalString simpleInternationalString2 = null;
                n = duration.getMonths();
                if (n != 0) {
                    simpleInternationalString2 = new SimpleInternationalString(Integer.toString(n));
                }
                InternationalString internationalString = null;
                SimpleInternationalString simpleInternationalString3 = null;
                n = duration.getDays();
                if (n != 0) {
                    simpleInternationalString3 = new SimpleInternationalString(Integer.toString(n));
                }
                SimpleInternationalString simpleInternationalString4 = null;
                n = duration.getHours();
                if (n != 0) {
                    simpleInternationalString4 = new SimpleInternationalString(Integer.toString(n));
                }
                SimpleInternationalString simpleInternationalString5 = null;
                n = duration.getMinutes();
                if (n != 0) {
                    simpleInternationalString5 = new SimpleInternationalString(Integer.toString(n));
                }
                SimpleInternationalString simpleInternationalString6 = null;
                n = duration.getSeconds();
                if (n != 0) {
                    simpleInternationalString6 = new SimpleInternationalString(Integer.toString(n));
                }
                return temporalFactory.createPeriodDuration(simpleInternationalString, simpleInternationalString2, internationalString, simpleInternationalString3, simpleInternationalString4, simpleInternationalString5, simpleInternationalString6);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                TM_PeriodDuration.warningOccured("toISO", unsupportedOperationException);
            }
        }
        return null;
    }

    private static void warningOccured(String string, Exception exception) {
        if (!exception.getMessage().contains("sis-temporal")) {
            Context.warningOccured(Context.current(), TM_PeriodDuration.class, string, exception, true);
        }
    }

    public static final class Since2014
    extends TM_PeriodDuration {
        @Override
        protected TM_PeriodDuration wrap(PeriodDuration periodDuration) {
            return this.accept2014() ? super.wrap(periodDuration) : null;
        }
    }
}

