/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.io.IOException;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatsOperation;
import net.spy.memcached.protocol.binary.SingleKeyOperationImpl;

public class KeyStatsOperationImpl
extends SingleKeyOperationImpl
implements StatsOperation {
    private static final byte CMD = 16;

    public KeyStatsOperationImpl(String key, StatsOperation.Callback c) {
        super((byte)16, KeyStatsOperationImpl.generateOpaque(), key, c);
    }

    @Override
    public void initialize() {
        String keyval = "key " + this.key + " " + this.getVBucket(this.key);
        this.prepareBuffer(keyval, 0L, EMPTY_BYTES, new Object[0]);
    }

    @Override
    protected void finishedPayload(byte[] pl) throws IOException {
        if (this.keyLen > 0) {
            byte[] keyBytes = new byte[this.keyLen];
            byte[] data = new byte[pl.length - this.keyLen];
            System.arraycopy(pl, 0, keyBytes, 0, this.keyLen);
            System.arraycopy(pl, this.keyLen, data, 0, pl.length - this.keyLen);
            StatsOperation.Callback cb = (StatsOperation.Callback)this.getCallback();
            cb.gotStat(new String(keyBytes, "UTF-8"), new String(data, "UTF-8"));
        } else {
            OperationStatus status = this.getStatusForErrorCode(this.errorCode, pl);
            this.getCallback().receivedStatus(status);
            this.transitionState(OperationState.COMPLETE);
        }
        this.resetInput();
    }
}

