/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A serviceRef references a service. It is identified by the \"serviceName\", \"clusterName\" (name of the cluster which the service belongs to) and an optional \"peerName\" (to reference a remote service i.e. services managed by other CM instances). To operate on the service object, use the API with those fields as parameters.")
public class ApiServiceRef {
    @SerializedName(value="peerName")
    private String peerName = null;
    @SerializedName(value="clusterName")
    private String clusterName = null;
    @SerializedName(value="serviceName")
    private String serviceName = null;
    @SerializedName(value="serviceDisplayName")
    private String serviceDisplayName = null;
    @SerializedName(value="serviceType")
    private String serviceType = null;

    public ApiServiceRef peerName(String peerName) {
        this.peerName = peerName;
        return this;
    }

    @ApiModelProperty(value="The name of the CM peer corresponding to the remote CM that manages the referenced service. This should only be set when referencing a remote service.")
    public String getPeerName() {
        return this.peerName;
    }

    public void setPeerName(String peerName) {
        this.peerName = peerName;
    }

    public ApiServiceRef clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @ApiModelProperty(value="The enclosing cluster for this service.")
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ApiServiceRef serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(value="The service name.")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public ApiServiceRef serviceDisplayName(String serviceDisplayName) {
        this.serviceDisplayName = serviceDisplayName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getServiceDisplayName() {
        return this.serviceDisplayName;
    }

    public void setServiceDisplayName(String serviceDisplayName) {
        this.serviceDisplayName = serviceDisplayName;
    }

    public ApiServiceRef serviceType(String serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @ApiModelProperty(value="The service type. This is available since version 32")
    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiServiceRef apiServiceRef = (ApiServiceRef)o;
        return Objects.equals(this.peerName, apiServiceRef.peerName) && Objects.equals(this.clusterName, apiServiceRef.clusterName) && Objects.equals(this.serviceName, apiServiceRef.serviceName) && Objects.equals(this.serviceDisplayName, apiServiceRef.serviceDisplayName) && Objects.equals(this.serviceType, apiServiceRef.serviceType);
    }

    public int hashCode() {
        return Objects.hash(this.peerName, this.clusterName, this.serviceName, this.serviceDisplayName, this.serviceType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiServiceRef {\n");
        sb.append("    peerName: ").append(this.toIndentedString(this.peerName)).append("\n");
        sb.append("    clusterName: ").append(this.toIndentedString(this.clusterName)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    serviceDisplayName: ").append(this.toIndentedString(this.serviceDisplayName)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString(this.serviceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

