/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.security;

import java.io.Console;
import java.util.Arrays;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.UsernamePassword;

public class PromptUtils {
    private static GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);

    public static char[] challengeUserForEstablishingMaterSecret() {
        boolean noMatch;
        char[] response = null;
        Console c = System.console();
        if (c == null) {
            LOG.unableToPromptForMasterUseKnoxCLI();
            System.err.println("No console.");
            System.exit(1);
        }
        do {
            char[] newPassword2;
            char[] newPassword1;
            boolean bl = noMatch = !Arrays.equals(newPassword1 = c.readPassword("Enter master secret: ", new Object[0]), newPassword2 = c.readPassword("Enter master secret again: ", new Object[0]));
            if (noMatch) {
                c.format("Passwords don't match. Try again.%n", new Object[0]);
            } else {
                response = Arrays.copyOf(newPassword1, newPassword1.length);
            }
            Arrays.fill(newPassword1, ' ');
            Arrays.fill(newPassword2, ' ');
        } while (noMatch);
        return response;
    }

    public static UsernamePassword challengeUserNamePassword(String prompt1, String prompt2) {
        UsernamePassword response = null;
        Console c = System.console();
        if (c == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        String username = c.readLine(prompt1 + ": ", new Object[0]);
        char[] pwd = c.readPassword(prompt2 + ": ", new Object[0]);
        response = new UsernamePassword(username, pwd);
        return response;
    }

    public static char[] challengeForPassword(String prompt) {
        char[] response = null;
        Console c = System.console();
        if (c == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        response = c.readPassword(prompt + ": ", new Object[0]);
        return response;
    }
}

