/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Config {
    static final String DEFAULT_NAME = "";
    static final String COMMENT_PREFIX = "#";
    static final String SECTION_PREFIX = "[";
    static final String SECTION_SUFFIX = "]";
    static final Pattern SECTION_PATTERN = Pattern.compile("^\\[(.*?)\\]?$");
    static final Pattern PAIR_PATTERN = Pattern.compile("^(.*?)=(.*)$");
    Map<String, Map<String, String>> sections = new LinkedHashMap<String, Map<String, String>>();

    public void load(Reader reader) throws IOException {
        if (reader != null) {
            BufferedReader input = new BufferedReader(reader);
            String profile = null;
            String line = input.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0 && !line.startsWith(COMMENT_PREFIX)) {
                    Matcher matcher;
                    if (line.startsWith(SECTION_PREFIX)) {
                        matcher = SECTION_PATTERN.matcher(line);
                        if (matcher.matches()) {
                            profile = matcher.group(1);
                        }
                    } else {
                        matcher = PAIR_PATTERN.matcher(line);
                        if (matcher.matches() && matcher.groupCount() > 0) {
                            String name = matcher.group(1);
                            String value = null;
                            if (matcher.groupCount() > 1) {
                                value = matcher.group(2);
                            }
                            this.set(profile, name, value);
                        }
                    }
                }
                line = input.readLine();
            }
        }
    }

    public void save(Writer writer) {
        boolean empty = true;
        if (writer != null) {
            PrintWriter output = new PrintWriter(writer);
            Map<String, String> map = this.sections.get(DEFAULT_NAME);
            if (map != null) {
                empty &= map.size() == 0;
                this.saveMap(output, map);
            }
            for (Map.Entry<String, Map<String, String>> entry : this.sections.entrySet()) {
                String section;
                if (!empty) {
                    output.println();
                }
                if ((section = entry.getKey()) == null || section.equals(DEFAULT_NAME)) continue;
                map = this.sections.get(section);
                output.print(SECTION_PREFIX);
                output.print(section);
                output.println(SECTION_SUFFIX);
                empty = false;
                this.saveMap(output, map);
            }
        }
    }

    void saveMap(PrintWriter output, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            output.print(entry.getKey());
            output.print("=");
            String value = entry.getValue();
            if (value == null) continue;
            output.print(entry.getValue());
        }
    }

    public String get(String section, String name) {
        section = Config.fixName(section);
        name = Config.fixName(name);
        String value = null;
        Map<String, String> map = this.sections.get(section);
        if (map != null && map.containsKey(name)) {
            value = map.get(name);
        } else {
            map = this.sections.get(DEFAULT_NAME);
            if (map != null) {
                value = map.get(name);
            }
        }
        return value;
    }

    public void set(String section, String name, String value) {
        section = Config.fixName(section);
        name = Config.fixName(name);
        Map<String, String> map = this.sections.get(section);
        if (map == null) {
            map = new LinkedHashMap<String, String>();
            this.sections.put(section, map);
        }
        map.put(name, value);
    }

    private static String fixName(String name) {
        return name == null ? DEFAULT_NAME : name.trim();
    }
}

