/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util.urltemplate;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.apache.knox.gateway.util.urltemplate.Evaluator;
import org.apache.knox.gateway.util.urltemplate.Expander;
import org.apache.knox.gateway.util.urltemplate.Matcher;
import org.apache.knox.gateway.util.urltemplate.Params;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Resolver;
import org.apache.knox.gateway.util.urltemplate.Template;

public class Rewriter {
    private Matcher<Template> rules = new Matcher();

    public static URI rewrite(URI inputUri, Template inputTemplate, Template outputTemplate, Resolver resolver, Evaluator evaluator) throws URISyntaxException {
        Rewriter rewriter = new Rewriter();
        rewriter.addRule(inputTemplate, outputTemplate);
        Template inputUriTemplate = Parser.parseLiteral(inputUri.toString());
        return rewriter.rewrite(inputUriTemplate, resolver, evaluator);
    }

    public void addRule(Template inputTemplate, Template outputTemplate) {
        this.rules.add(inputTemplate, outputTemplate);
    }

    public URI rewrite(Template input, Resolver resolver, Evaluator evaluator) throws URISyntaxException {
        URI outputUri = null;
        Matcher.Match match = this.rules.match(input);
        if (match != null) {
            Params params = resolver == null ? match.getParams() : new RewriteParams(match.getParams(), new Resolver[]{resolver});
            outputUri = Expander.expand((Template)match.getValue(), params, evaluator);
        }
        return outputUri;
    }

    private static class RewriteParams
    implements Params {
        private Params params;
        private Resolver[] resolvers;

        private RewriteParams(Params params, Resolver ... resolvers) {
            this.params = params;
            this.resolvers = resolvers;
        }

        @Override
        public Set<String> getNames() {
            return this.params.getNames();
        }

        @Override
        public List<String> resolve(String name) {
            List<String> values = this.params.resolve(name);
            if (values == null && this.resolvers != null) {
                Resolver resolver;
                Resolver[] resolverArray = this.resolvers;
                int n = resolverArray.length;
                for (int i = 0; i < n && (values = (resolver = resolverArray[i]).resolve(name)) == null; ++i) {
                }
            }
            return values;
        }
    }
}

