/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import java.security.cert.X509Certificate;
import java.text.ParseException;

public enum KeyUse {
    SIGNATURE("sig"),
    ENCRYPTION("enc");

    private final String identifier;

    private KeyUse(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("The key use identifier must not be null");
        }
        this.identifier = identifier;
    }

    public String identifier() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier();
    }

    public static KeyUse parse(String s) throws ParseException {
        if (s == null) {
            return null;
        }
        for (KeyUse use : KeyUse.values()) {
            if (!s.equals(use.identifier)) continue;
            return use;
        }
        throw new ParseException("Invalid JWK use: " + s, 0);
    }

    public static KeyUse from(X509Certificate cert) {
        if (cert.getKeyUsage() == null) {
            return null;
        }
        if (cert.getKeyUsage()[1]) {
            return SIGNATURE;
        }
        if (cert.getKeyUsage()[0] && cert.getKeyUsage()[2]) {
            return ENCRYPTION;
        }
        if (cert.getKeyUsage()[0] && cert.getKeyUsage()[4]) {
            return ENCRYPTION;
        }
        if (cert.getKeyUsage()[2] || cert.getKeyUsage()[3] || cert.getKeyUsage()[4]) {
            return ENCRYPTION;
        }
        if (cert.getKeyUsage()[5] || cert.getKeyUsage()[6]) {
            return SIGNATURE;
        }
        return null;
    }
}

