/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.MasterService;

public class DefaultAliasService
implements AliasService {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final String GATEWAY_IDENTITY_PASSPHRASE = "gateway-identity-passphrase";
    protected static char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9'};
    private KeystoreService keystoreService;
    private MasterService masterService;

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    public char[] getGatewayIdentityPassphrase() throws AliasServiceException {
        char[] passphrase = this.getPasswordFromAliasForGateway(GATEWAY_IDENTITY_PASSPHRASE);
        if (passphrase == null) {
            passphrase = this.masterService.getMasterSecret();
        }
        return passphrase;
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster(clusterName, alias, false);
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias, boolean generate) throws AliasServiceException {
        char[] credential = null;
        try {
            credential = this.keystoreService.getCredentialForCluster(clusterName, alias);
            if (credential == null && generate) {
                this.generateAliasForCluster(clusterName, alias);
                credential = this.keystoreService.getCredentialForCluster(clusterName, alias);
            }
        }
        catch (KeystoreServiceException e) {
            LOG.failedToGetCredentialForCluster(clusterName, (Exception)((Object)e));
            throw new AliasServiceException((Exception)((Object)e));
        }
        return credential;
    }

    protected static String generatePassword(int length) {
        StringBuilder sb = new StringBuilder();
        SecureRandom r = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            sb.append(chars[r.nextInt(chars.length)]);
        }
        return sb.toString();
    }

    public void setKeystoreService(KeystoreService ks) {
        this.keystoreService = ks;
    }

    public void setMasterService(MasterService ms) {
        this.masterService = ms;
    }

    public void generateAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        try {
            this.keystoreService.getCredentialStoreForCluster(clusterName);
        }
        catch (KeystoreServiceException e) {
            LOG.failedToGenerateAliasForCluster(clusterName, e);
            throw new AliasServiceException((Exception)((Object)e));
        }
        String passwordString = DefaultAliasService.generatePassword(16);
        this.addAliasForCluster(clusterName, alias, passwordString);
    }

    public void addAliasForCluster(String clusterName, String alias, String value) {
        try {
            this.keystoreService.addCredentialForCluster(clusterName, alias, value);
        }
        catch (KeystoreServiceException e) {
            LOG.failedToAddCredentialForCluster(clusterName, (Exception)((Object)e));
        }
    }

    public void removeAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        try {
            this.keystoreService.removeCredentialForCluster(clusterName, alias);
        }
        catch (KeystoreServiceException e) {
            throw new AliasServiceException((Exception)((Object)e));
        }
    }

    public char[] getPasswordFromAliasForGateway(String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster("__gateway", alias);
    }

    public void generateAliasForGateway(String alias) throws AliasServiceException {
        this.generateAliasForCluster("__gateway", alias);
    }

    public Certificate getCertificateForGateway(String alias) {
        Certificate cert = null;
        try {
            cert = this.keystoreService.getKeystoreForGateway().getCertificate(alias);
        }
        catch (KeyStoreException e) {
            LOG.unableToRetrieveCertificateForGateway(e);
        }
        catch (KeystoreServiceException e) {
            LOG.unableToRetrieveCertificateForGateway((Exception)((Object)e));
        }
        return cert;
    }

    public List<String> getAliasesForCluster(String clusterName) {
        ArrayList<String> list;
        block5: {
            list = new ArrayList<String>();
            try {
                KeyStore keyStore = this.keystoreService.getCredentialStoreForCluster(clusterName);
                if (keyStore == null) break block5;
                String alias = null;
                try {
                    Enumeration<String> e = keyStore.aliases();
                    while (e.hasMoreElements()) {
                        alias = e.nextElement();
                        if (alias.contains("@")) continue;
                        list.add(alias);
                    }
                }
                catch (KeyStoreException e) {
                    LOG.failedToGetCredentialForCluster(clusterName, e);
                }
            }
            catch (KeystoreServiceException kse) {
                LOG.failedToGetCredentialForCluster(clusterName, (Exception)((Object)kse));
            }
        }
        return list;
    }
}

