/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;

public class GatewayForwardingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String AUDIT_ACTION = "forward";
    private static final GatewayResources RES = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");
    private String redirectToContext = null;

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.redirectToContext = config.getInitParameter("redirectTo");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String origPath = GatewayForwardingServlet.getRequestPath(request);
        try {
            auditService.createContext();
            String origRequest = GatewayForwardingServlet.getRequestLine(request);
            auditor.audit(AUDIT_ACTION, origPath, "uri", "unavailable", RES.forwardToDefaultTopology(request.getMethod(), this.redirectToContext));
            ServletContext ctx = this.getServletContext().getContext(this.redirectToContext);
            RequestDispatcher dispatcher = ctx.getRequestDispatcher(origRequest);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            auditor.audit(AUDIT_ACTION, origPath, "uri", "success", RES.responseStatus(response.getStatus()));
        }
        catch (IOException | RuntimeException | ServletException e) {
            auditor.audit(AUDIT_ACTION, origPath, "uri", "failure");
            throw e;
        }
        catch (Throwable e) {
            auditor.audit(AUDIT_ACTION, origPath, "uri", "failure");
            throw new ServletException(e);
        }
        finally {
            auditService.detachContext();
        }
    }

    private static final String getRequestPath(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null) {
            return "";
        }
        return path;
    }

    private static final String getRequestLine(HttpServletRequest request) {
        String path = GatewayForwardingServlet.getRequestPath(request);
        String query = request.getQueryString();
        if (query == null) {
            return path;
        }
        return path + "?" + query;
    }
}

