/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.terracotta.TerracottaClient;
import net.sf.ehcache.transaction.SoftLockManager;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.writer.writebehind.WriteBehind;

public class ClusteredInstanceFactoryWrapper
implements ClusteredInstanceFactory {
    private final TerracottaClient client;
    private final ClusteredInstanceFactory delegate;

    public ClusteredInstanceFactoryWrapper(TerracottaClient client, ClusteredInstanceFactory delegate) {
        this.client = client;
        this.delegate = delegate;
    }

    protected ClusteredInstanceFactory getActualFactory() {
        return this.delegate;
    }

    @Override
    public CacheCluster getTopology() {
        this.client.waitUntilRejoinComplete();
        return this.client.getCacheCluster();
    }

    @Override
    public String getUUID() {
        this.client.waitUntilRejoinComplete();
        return this.delegate.getUUID();
    }

    @Override
    public CacheEventListener createEventReplicator(Ehcache cache) {
        this.client.waitUntilRejoinComplete();
        return this.delegate.createEventReplicator(cache);
    }

    @Override
    public Store createStore(Ehcache cache) {
        this.client.waitUntilRejoinComplete();
        return this.delegate.createStore(cache);
    }

    @Override
    public TransactionIDFactory createTransactionIDFactory(String uuid, String cacheManagerName) {
        this.client.waitUntilRejoinComplete();
        return this.delegate.createTransactionIDFactory(uuid, cacheManagerName);
    }

    @Override
    public WriteBehind createWriteBehind(Ehcache cache) {
        this.client.waitUntilRejoinComplete();
        return this.delegate.createWriteBehind(cache);
    }

    @Override
    public SoftLockManager getOrCreateSoftLockManager(Ehcache cache) {
        this.client.waitUntilRejoinComplete();
        return this.delegate.getOrCreateSoftLockManager(cache);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }
}

