/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.sasl.plain;

import java.io.IOException;
import javax.naming.InvalidNameException;
import javax.security.sasl.SaslException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.schema.PrepareString;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.sasl.AbstractSaslServer;

public class PlainSaslServer
extends AbstractSaslServer {
    public static final String SASL_PLAIN_AUTHZID = "authzid";
    public static final String SASL_PLAIN_AUTHCID = "authcid";
    public static final String SASL_PLAIN_PASSWORD = "password";
    private NegotiationState state = NegotiationState.INITIALIZED;

    public PlainSaslServer(LdapSession ldapSession, CoreSession adminSession, BindRequest bindRequest) {
        super(ldapSession, adminSession, bindRequest);
        this.getLdapSession().removeSaslProperty(SASL_PLAIN_AUTHZID);
        this.getLdapSession().removeSaslProperty(SASL_PLAIN_AUTHCID);
        this.getLdapSession().removeSaslProperty(SASL_PLAIN_PASSWORD);
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public byte[] evaluateResponse(byte[] initialResponse) throws SaslException {
        if (Strings.isEmpty(initialResponse)) {
            this.state = NegotiationState.MECH_RECEIVED;
            return null;
        }
        InitialResponse element = InitialResponse.AUTHZID_EXPECTED;
        String authzId = null;
        String authcId = null;
        String password = null;
        int start = 0;
        int end = 0;
        try {
            for (byte b : initialResponse) {
                if (b == 0) {
                    if (start - end == 0) {
                        if (element == InitialResponse.AUTHZID_EXPECTED) {
                            element = InitialResponse.AUTHCID_EXPECTED;
                            continue;
                        }
                        throw new IllegalArgumentException(I18n.err(I18n.ERR_671, new Object[0]));
                    }
                    String value = new String(initialResponse, ++start, end - start + 1, "UTF-8");
                    switch (element) {
                        case AUTHZID_EXPECTED: {
                            element = InitialResponse.AUTHCID_EXPECTED;
                            authzId = PrepareString.normalize(value, PrepareString.StringType.CASE_EXACT_IA5);
                            start = ++end;
                            break;
                        }
                        case AUTHCID_EXPECTED: {
                            element = InitialResponse.PASSWORD_EXPECTED;
                            authcId = PrepareString.normalize(value, PrepareString.StringType.DIRECTORY_STRING);
                            start = ++end;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(I18n.err(I18n.ERR_672, new Object[0]));
                        }
                    }
                    continue;
                }
                ++end;
            }
            if (start == end) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_671, new Object[0]));
            }
            String value = Strings.utf8ToString(initialResponse, ++start, end - start + 1);
            password = PrepareString.normalize(value, PrepareString.StringType.CASE_EXACT_IA5);
            if (authcId == null || password == null) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_671, new Object[0]));
            }
            CoreSession userSession = this.authenticate(authcId, password);
            this.getLdapSession().setCoreSession(userSession);
            this.state = NegotiationState.COMPLETED;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_674, new Object[0]));
        }
        catch (InvalidNameException ine) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_675, new Object[0]));
        }
        catch (Exception e) {
            throw new SaslException(I18n.err(I18n.ERR_676, authcId));
        }
        return Strings.EMPTY_BYTES;
    }

    @Override
    public boolean isComplete() {
        return this.state == NegotiationState.COMPLETED;
    }

    private CoreSession authenticate(String user, String password) throws InvalidNameException, Exception {
        LdapSession ldapSession = this.getLdapSession();
        CoreSession adminSession = this.getAdminSession();
        DirectoryService directoryService = adminSession.getDirectoryService();
        LdapServer ldapServer = ldapSession.getLdapServer();
        OperationManager operationManager = directoryService.getOperationManager();
        EqualityNode<String> filter = new EqualityNode<String>(directoryService.getSchemaManager().getAttributeType("uid"), new StringValue(user));
        SearchOperationContext searchContext = new SearchOperationContext(directoryService.getAdminSession());
        searchContext.setDn(directoryService.getDnFactory().create(ldapServer.getSearchBaseDn()));
        searchContext.setScope(SearchScope.SUBTREE);
        searchContext.setFilter(filter);
        searchContext.setNoAttributes(true);
        EntryFilteringCursor cursor = operationManager.search(searchContext);
        Exception bindException = new LdapAuthenticationException("Cannot authenticate user uid=" + user);
        while (cursor.next()) {
            Entry entry = (Entry)cursor.get();
            try {
                BindOperationContext bindContext = new BindOperationContext(ldapSession.getCoreSession());
                bindContext.setDn(entry.getDn());
                bindContext.setCredentials(Strings.getBytesUtf8(password));
                bindContext.setIoSession(ldapSession.getIoSession());
                bindContext.setInterceptors(directoryService.getInterceptors(OperationEnum.BIND));
                operationManager.bind(bindContext);
                cursor.close();
                return bindContext.getSession();
            }
            catch (Exception e) {
                bindException = e;
            }
        }
        cursor.close();
        throw bindException;
    }

    private static enum InitialResponse {
        AUTHZID_EXPECTED,
        AUTHCID_EXPECTED,
        PASSWORD_EXPECTED;

    }

    private static enum NegotiationState {
        INITIALIZED,
        MECH_RECEIVED,
        COMPLETED;

    }
}

