/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;

public class ExtendedRequestHandler<R extends ExtendedRequest>
extends LdapRequestHandler<ExtendedRequest> {
    @Override
    public void handle(LdapSession session, ExtendedRequest req) throws Exception {
        ExtendedOperationHandler<? extends ExtendedRequest, ? extends ExtendedResponse> handler = this.getLdapServer().getExtendedOperationHandler(req.getRequestName());
        if (handler == null) {
            String msg = "Unrecognized extended operation EXTENSION_OID: " + req.getRequestName();
            LdapResult result = req.getResultResponse().getLdapResult();
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setDiagnosticMessage(msg);
            session.getIoSession().write(req.getResultResponse());
            return;
        }
        try {
            handler.handleExtendedOperation(session, req);
        }
        catch (Exception e) {
            LdapResult result = req.getResultResponse().getLdapResult();
            result.setResultCode(ResultCodeEnum.OTHER);
            result.setDiagnosticMessage((Object)((Object)ResultCodeEnum.OTHER) + ": Extended operation handler for the specified EXTENSION_OID (" + req.getRequestName() + ") has failed to process your request:\n" + ExceptionUtils.getStackTrace(e));
            ResultResponse resp = req.getResultResponse();
            session.getIoSession().write(resp);
        }
    }
}

