/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AbstractAbandonableRequest;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.AddResponseImpl;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.name.Dn;

public class AddRequestImpl
extends AbstractAbandonableRequest
implements AddRequest {
    static final long serialVersionUID = 7534132448349520346L;
    private Entry entry = new DefaultEntry();
    private AddResponse response;
    private Attribute currentAttribute;

    public AddRequestImpl() {
        super(-1, MessageTypeEnum.ADD_REQUEST);
    }

    public void addAttributeType(String type) throws LdapException {
        if (this.entry.get(type) != null) {
            this.currentAttribute = this.entry.get(type);
            return;
        }
        this.currentAttribute = new DefaultAttribute(type);
        this.entry.put(this.currentAttribute);
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getId();
    }

    public void addAttributeValue(String value) throws LdapException {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(Value<?> value) throws LdapException {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(byte[] value) throws LdapException {
        this.currentAttribute.add(new byte[][]{value});
    }

    @Override
    public Dn getEntryDn() {
        return this.entry.getDn();
    }

    @Override
    public AddRequest setEntryDn(Dn dn) {
        this.entry.setDn(dn);
        return this;
    }

    @Override
    public Entry getEntry() {
        return this.entry;
    }

    @Override
    public AddRequest setEntry(Entry entry) {
        this.entry = entry;
        return this;
    }

    @Override
    public AddRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AddRequest addControl(Control control) {
        return (AddRequest)super.addControl(control);
    }

    @Override
    public AddRequest addAllControls(Control[] controls) {
        return (AddRequest)super.addAllControls(controls);
    }

    @Override
    public AddRequest removeControl(Control control) {
        return (AddRequest)super.removeControl(control);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return MessageTypeEnum.ADD_RESPONSE;
    }

    @Override
    public AddResponse getResultResponse() {
        if (this.response == null) {
            this.response = new AddResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AddRequest)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AddRequest req = (AddRequest)obj;
        if (this.entry == null) {
            return req.getEntry() == null;
        }
        return this.entry.equals(req.getEntry());
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + (this.entry == null ? 0 : this.entry.hashCode());
        hash = hash * 17 + (this.response == null ? 0 : this.response.hashCode());
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Add Request :\n");
        if (this.entry == null) {
            sb.append("            No entry\n");
        } else {
            sb.append(this.entry.toString());
        }
        return super.toString(sb.toString());
    }
}

