/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.AttributeValueAssertion;
import org.apache.directory.api.ldap.codec.search.Filter;
import org.apache.directory.api.ldap.model.entry.Value;

public class AttributeValueAssertionFilter
extends Filter {
    private AttributeValueAssertion assertion;
    private int filterType;
    private int avaLength;

    public AttributeValueAssertionFilter(int tlvId, int filterType) {
        super(tlvId);
        this.filterType = filterType;
    }

    public AttributeValueAssertionFilter(int filterType) {
        this.filterType = filterType;
    }

    public AttributeValueAssertion getAssertion() {
        return this.assertion;
    }

    public void setAssertion(AttributeValueAssertion assertion) {
        this.assertion = assertion;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setFilterType(int filterType) {
        this.filterType = filterType;
    }

    @Override
    public int computeLength() {
        this.avaLength = 0;
        int attributeDescLength = this.assertion.getAttributeDesc().length();
        this.avaLength = 1 + TLV.getNbBytes(attributeDescLength) + attributeDescLength;
        Value<?> assertionValue = this.assertion.getAssertionValue();
        int assertionValueLength = assertionValue.getBytes().length;
        this.avaLength += 1 + TLV.getNbBytes(assertionValueLength) + assertionValueLength;
        return 1 + TLV.getNbBytes(this.avaLength) + this.avaLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        try {
            switch (this.filterType) {
                case 0: {
                    buffer.put((byte)-93);
                    break;
                }
                case 2: {
                    buffer.put((byte)-90);
                    break;
                }
                case 1: {
                    buffer.put((byte)-91);
                    break;
                }
                case 3: {
                    buffer.put((byte)-88);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected filter type: " + this.filterType);
                }
            }
            buffer.put(TLV.getBytes(this.avaLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]), boe);
        }
        BerValue.encode(buffer, this.assertion.getAttributeDesc());
        if (this.assertion.getAssertionValue().isHumanReadable()) {
            BerValue.encode(buffer, this.assertion.getAssertionValue().getString());
        } else {
            BerValue.encode(buffer, this.assertion.getAssertionValue().getBytes());
        }
        return buffer;
    }

    public String toString() {
        return this.assertion != null ? this.assertion.toStringRFC2254(this.filterType) : "";
    }
}

