/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.sort;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestContainer;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestStates;
import org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SortRequestGrammar
extends AbstractGrammar<SortRequestContainer> {
    static final Logger LOG = LoggerFactory.getLogger(SortRequestGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<SortRequestContainer> instance = new SortRequestGrammar();

    private SortRequestGrammar() {
        this.setName(SortRequestGrammar.class.getName());
        GrammarAction<SortRequestContainer> addSortKey = new GrammarAction<SortRequestContainer>(){

            @Override
            public void action(SortRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String atDesc = Strings.utf8ToString(value.getData());
                if (IS_DEBUG) {
                    LOG.debug("AttributeTypeDesc = " + atDesc);
                }
                SortKey sk = new SortKey(atDesc);
                container.setCurrentKey(sk);
                container.getControl().addSortKey(sk);
                container.setGrammarEndAllowed(true);
            }
        };
        GrammarAction<SortRequestContainer> storeReverseOrder = new GrammarAction<SortRequestContainer>(){

            @Override
            public void action(SortRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean reverseOrder = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("ReverseOrder = " + reverseOrder);
                    }
                    container.getCurrentKey().setReverseOrder(reverseOrder);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException bde) {
                    throw new DecoderException(bde.getMessage(), bde);
                }
            }
        };
        this.transitions = new GrammarTransition[SortRequestStates.END_STATE.ordinal()][256];
        this.transitions[SortRequestStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(SortRequestStates.START_STATE, SortRequestStates.SEQUENCE_OF_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SortRequestStates.SEQUENCE_OF_SEQUENCE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(SortRequestStates.SEQUENCE_OF_SEQUENCE_STATE, SortRequestStates.SORT_KEY_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SortRequestStates.SORT_KEY_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SortRequestContainer>(SortRequestStates.SORT_KEY_SEQUENCE_STATE, SortRequestStates.AT_DESC_STATE, UniversalTag.OCTET_STRING.getValue(), addSortKey);
        this.transitions[SortRequestStates.AT_DESC_STATE.ordinal()][128] = new GrammarTransition<SortRequestContainer>(SortRequestStates.AT_DESC_STATE, SortRequestStates.ORDER_RULE_STATE, 128, new GrammarAction<SortRequestContainer>(){

            @Override
            public void action(SortRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String matchingRuleOid = Strings.utf8ToString(value.getData());
                if (IS_DEBUG) {
                    LOG.debug("MatchingRuleOid = " + matchingRuleOid);
                }
                container.getCurrentKey().setMatchingRuleId(matchingRuleOid);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SortRequestStates.ORDER_RULE_STATE.ordinal()][129] = new GrammarTransition<SortRequestContainer>(SortRequestStates.ORDER_RULE_STATE, SortRequestStates.REVERSE_ORDER_STATE, 129, storeReverseOrder);
        this.transitions[SortRequestStates.AT_DESC_STATE.ordinal()][129] = new GrammarTransition<SortRequestContainer>(SortRequestStates.AT_DESC_STATE, SortRequestStates.REVERSE_ORDER_STATE, 129, storeReverseOrder);
        this.transitions[SortRequestStates.REVERSE_ORDER_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(SortRequestStates.REVERSE_ORDER_STATE, SortRequestStates.SORT_KEY_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SortRequestStates.AT_DESC_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(SortRequestStates.AT_DESC_STATE, SortRequestStates.SORT_KEY_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

