/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.hbase.table.row;

import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.transform.Transformer;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.EmptyResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.hbase.table.row.InsertableColumn;
import org.apache.knox.gateway.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StoreRow {

    public static class Response
    extends EmptyResponse {
        Response(HttpResponse response) {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private static final String ELEMENT_CELL_SET = "CellSet";
        private static final String ELEMENT_ROW = "Row";
        private static final String ELEMENT_CELL = "Cell";
        private static final String ATTRIBUTE_KEY = "key";
        private static final String ATTRIBUTE_COLUMN = "column";
        private static final String ATTRIBUTE_TIMESTAMP = "timestamp";
        private String rowId;
        private String tableName;
        private List<InsertableColumn> columns = new ArrayList<InsertableColumn>();

        public Request(KnoxSession session, String rowId, String tableName) {
            super(session);
            this.rowId = rowId;
            this.tableName = tableName;
        }

        public Request column(String family, String qualifier, Object value, Long time) {
            this.columns.add(new InsertableColumn(family, qualifier, value, time));
            return this;
        }

        public Request column(String family, String qualifier, Object value) {
            this.columns.add(new InsertableColumn(family, qualifier, value, null));
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    Document document = XmlUtils.createDocument();
                    Element root = document.createElement(Request.ELEMENT_CELL_SET);
                    document.appendChild(root);
                    Element row = document.createElement(Request.ELEMENT_ROW);
                    row.setAttribute(Request.ATTRIBUTE_KEY, Base64.encodeBase64String((byte[])rowId.getBytes(StandardCharsets.UTF_8)));
                    root.appendChild(row);
                    for (InsertableColumn column : columns) {
                        Element cell = document.createElement(Request.ELEMENT_CELL);
                        cell.setAttribute(Request.ATTRIBUTE_COLUMN, column.encodedName());
                        if (column.time() != null) {
                            cell.setAttribute(Request.ATTRIBUTE_TIMESTAMP, column.time().toString());
                        }
                        cell.setTextContent(column.encodedValue());
                        row.appendChild(cell);
                    }
                    StringWriter writer = new StringWriter();
                    Transformer t = XmlUtils.getTransformer((boolean)true, (boolean)false, (int)0, (boolean)false);
                    XmlUtils.writeXml((Document)document, (Writer)writer, (Transformer)t);
                    URIBuilder uri = this.uri(new String[]{"/hbase", "/", tableName, "/false-row-key"});
                    HttpPost request = new HttpPost(uri.build());
                    StringEntity entity = new StringEntity(writer.toString(), ContentType.create((String)"text/xml", (Charset)StandardCharsets.UTF_8));
                    request.setEntity((HttpEntity)entity);
                    return new Response((HttpResponse)this.execute((HttpRequest)request));
                }
            };
        }
    }
}

