/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.filter;

import java.io.IOException;
import java.text.ParseException;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.provider.federation.jwt.filter.AbstractJWTFilter;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.util.CertificateUtils;

public class JWTFederationFilter
extends AbstractJWTFilter {
    public static final String KNOX_TOKEN_AUDIENCES = "knox.token.audiences";
    public static final String TOKEN_VERIFICATION_PEM = "knox.token.verification.pem";
    private static final String KNOX_TOKEN_QUERY_PARAM_NAME = "knox.token.query.param.name";
    private static final String BEARER = "Bearer ";
    private String paramName = "knoxtoken";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String verificationPEM;
        String queryParamName;
        super.init(filterConfig);
        String expectedAudiences = filterConfig.getInitParameter(KNOX_TOKEN_AUDIENCES);
        if (expectedAudiences != null) {
            this.audiences = this.parseExpectedAudiences(expectedAudiences);
        }
        if ((queryParamName = filterConfig.getInitParameter(KNOX_TOKEN_QUERY_PARAM_NAME)) != null) {
            this.paramName = queryParamName;
        }
        if ((verificationPEM = filterConfig.getInitParameter(TOKEN_VERIFICATION_PEM)) != null) {
            this.publicKey = CertificateUtils.parseRSAPublicKey((String)verificationPEM);
        }
        this.configureExpectedParameters(filterConfig);
    }

    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String header = ((HttpServletRequest)request).getHeader("Authorization");
        String wireToken = null;
        wireToken = header != null && header.startsWith(BEARER) ? header.substring(BEARER.length()) : ((HttpServletRequest)request).getParameter(this.paramName);
        if (wireToken != null) {
            try {
                JWTToken token = new JWTToken(wireToken);
                if (this.validateToken((HttpServletRequest)request, (HttpServletResponse)response, chain, (JWT)token)) {
                    Subject subject = this.createSubjectFromToken((JWT)token);
                    this.continueWithEstablishedSecurityContext(subject, (HttpServletRequest)request, (HttpServletResponse)response, chain);
                }
            }
            catch (ParseException ex) {
                ((HttpServletResponse)response).sendError(401);
            }
        } else {
            ((HttpServletResponse)response).sendError(401);
        }
    }

    @Override
    protected void handleValidationError(HttpServletRequest request, HttpServletResponse response, int status, String error) throws IOException {
        if (error != null) {
            response.sendError(status, error);
        } else {
            response.sendError(status);
        }
    }
}

