/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class FunctionQuery
extends Query {
    final ValueSource func;

    public FunctionQuery(ValueSource func) {
        this.func = func;
    }

    public ValueSource getValueSource() {
        return this.func;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new FunctionWeight(searcher, boost);
    }

    @Override
    public String toString(String field) {
        return this.func.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.func.equals(((FunctionQuery)other).func);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.func.hashCode();
    }

    protected class AllScorer
    extends Scorer {
        final IndexReader reader;
        final FunctionWeight weight;
        final int maxDoc;
        final float boost;
        final DocIdSetIterator iterator;
        final FunctionValues vals;

        public AllScorer(LeafReaderContext context2, FunctionWeight w, float boost) throws IOException {
            super(w);
            this.weight = w;
            this.boost = boost;
            this.reader = context2.reader();
            this.maxDoc = this.reader.maxDoc();
            this.iterator = DocIdSetIterator.all(context2.reader().maxDoc());
            this.vals = FunctionQuery.this.func.getValues(this.weight.context, context2);
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        @Override
        public int docID() {
            return this.iterator.docID();
        }

        @Override
        public float score() throws IOException {
            float val = this.vals.floatVal(this.docID());
            if (!(val >= 0.0f)) {
                return 0.0f;
            }
            return this.boost * val;
        }

        @Override
        public float getMaxScore(int upTo) throws IOException {
            return Float.POSITIVE_INFINITY;
        }

        public Explanation explain(int doc) throws IOException {
            Explanation expl = this.vals.explain(doc);
            if (expl.getValue().floatValue() < 0.0f) {
                expl = Explanation.match((Number)0, "truncated score, max of:", Explanation.match((Number)Float.valueOf(0.0f), "minimum score", new Explanation[0]), expl);
            } else if (Float.isNaN(expl.getValue().floatValue())) {
                expl = Explanation.match((Number)0, "score, computed as (score == NaN ? 0 : score) since NaN is an illegal score from:", expl);
            }
            return Explanation.match((Number)Float.valueOf(this.boost * expl.getValue().floatValue()), "FunctionQuery(" + FunctionQuery.this.func + "), product of:", this.vals.explain(doc), Explanation.match((Number)Float.valueOf(this.weight.boost), "boost", new Explanation[0]));
        }
    }

    protected class FunctionWeight
    extends Weight {
        protected final IndexSearcher searcher;
        protected final float boost;
        protected final Map<Object, Object> context;

        public FunctionWeight(IndexSearcher searcher, float boost) throws IOException {
            super(FunctionQuery.this);
            this.searcher = searcher;
            this.context = ValueSource.newContext(searcher);
            FunctionQuery.this.func.createWeight(this.context, searcher);
            this.boost = boost;
        }

        @Override
        public Scorer scorer(LeafReaderContext context2) throws IOException {
            return new AllScorer(context2, this, this.boost);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        @Override
        public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
            return ((AllScorer)this.scorer(context2)).explain(doc);
        }
    }
}

