/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.jena.rfc3986.Chars3986;
import org.apache.jena.rfc3986.IRIParseException;

public class ParseDNS {
    private final String string;
    private final int length;
    private static char HYPHEN = (char)45;

    private ParseDNS(String string) {
        this.string = string;
        this.length = string.length();
    }

    public static String parse(String string) {
        Objects.requireNonNull(string);
        new ParseDNS(string).parse(false);
        return string;
    }

    private void error(String msg) {
        throw new DNSParseException(msg);
    }

    private char charAt(int x) {
        if (x >= this.length) {
            return '\uffff';
        }
        return this.string.charAt(x);
    }

    private void parse(boolean allowPercentEncoding) {
        int end = this.length;
        int p = 0;
        if (this.length == 0) {
            this.error("Empty string");
        }
        if (this.length == 1 && this.string.equals(" ")) {
            this.error("Empty string");
        }
        if (this.length == 1 && this.string.equals(".")) {
            this.error("No subdomains.");
        }
        ArrayList<Integer> dots = new ArrayList<Integer>(4);
        while (p < end) {
            if ((p = this.label(p)) < 0) {
                this.error("No label");
            }
            if (p == this.length) break;
            dots.add(p - 1);
        }
    }

    private int label(int p) {
        int end = this.length;
        int start = p;
        boolean charIsHyphen = false;
        while (p < end) {
            char ch = this.charAt(p);
            if (ch == '.') {
                if (charIsHyphen) {
                    this.error("Bad last character of subdomain: '-'");
                }
                ++p;
                break;
            }
            boolean bl = charIsHyphen = ch == HYPHEN;
            if (!this.letter_digit(ch, p) && !charIsHyphen) {
                this.error("Bad character: '" + Character.toString(ch) + "'");
            }
            if (p == start && charIsHyphen) {
                this.error("Bad first character of subdomain: '" + Character.toString(ch) + "'");
            }
            ++p;
        }
        if (charIsHyphen) {
            this.error("Bad last character of subdomain: '-'");
        }
        if (p != end && start + 1 == p) {
            this.error("Zero length subdomain");
        }
        return p;
    }

    private boolean letter_digit(char ch, int x) {
        return this.i_letter(ch, x) || ParseDNS.digit(ch);
    }

    private boolean i_letter(char ch, int x) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || Chars3986.isUcsChar(ch) || Chars3986.isPctEncoded(ch, this.string, x);
    }

    private static boolean digit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    static class DNSParseException
    extends IRIParseException {
        DNSParseException(String msg) {
            super(msg);
        }
    }
}

