/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.access;

import java.io.IOException;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowIterator;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.core.access.ElasticSerializableRowRecordListBackedMultiColumnRow;
import org.apache.iotdb.db.query.udf.core.access.ElasticSerializableRowRecordListBackedMultiColumnWindowIterator;
import org.apache.iotdb.db.query.udf.core.access.EmptyRowIterator;
import org.apache.iotdb.db.query.udf.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ElasticSerializableRowRecordListBackedMultiColumnWindow
implements RowWindow {
    private final ElasticSerializableRowRecordList rowRecordList;
    private final TSDataType[] dataTypes;
    private int beginIndex;
    private int endIndex;
    private int size;
    private long startTime;
    private long endTime;
    private final ElasticSerializableRowRecordListBackedMultiColumnRow row;
    private ElasticSerializableRowRecordListBackedMultiColumnWindowIterator rowIterator;

    public ElasticSerializableRowRecordListBackedMultiColumnWindow(ElasticSerializableRowRecordList rowRecordList) {
        this.rowRecordList = rowRecordList;
        this.dataTypes = rowRecordList.getDataTypes();
        this.beginIndex = 0;
        this.endIndex = 0;
        this.size = 0;
        this.row = new ElasticSerializableRowRecordListBackedMultiColumnRow(this.dataTypes);
    }

    @Override
    public int windowSize() {
        return this.size;
    }

    @Override
    public Row getRow(int rowIndex) throws IOException {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Size is 0");
        }
        return this.row.setRowRecord(this.rowRecordList.getRowRecord(this.beginIndex + rowIndex));
    }

    @Override
    public TSDataType getDataType(int columnIndex) {
        return this.dataTypes[columnIndex];
    }

    @Override
    public RowIterator getRowIterator() {
        if (this.size == 0) {
            return new EmptyRowIterator();
        }
        if (this.rowIterator == null) {
            this.rowIterator = new ElasticSerializableRowRecordListBackedMultiColumnWindowIterator(this.rowRecordList, this.beginIndex, this.endIndex);
        }
        this.rowIterator.reset();
        return this.rowIterator;
    }

    public void setEmptyWindow(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.size = 0;
    }

    @Override
    public long windowStartTime() {
        return this.startTime;
    }

    @Override
    public long windowEndTime() {
        return this.endTime;
    }

    public void seek(int beginIndex, int endIndex, long startTime, long endTime) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.size = endIndex - beginIndex;
        this.startTime = startTime;
        this.endTime = endTime;
        this.rowIterator = null;
    }
}

