/// <reference types="react" />
import { EditorInitArgs, EditorTheme, KogitoEditorEnvelopeContextType } from "@kie-tools-core/editor/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { ServerlessWorkflowCombinedEditorApi, ServerlessWorkflowCombinedEditorChannelApi } from "../api";
import { Position } from "monaco-editor";
export declare class ServerlessWorkflowCombinedEditorView implements ServerlessWorkflowCombinedEditorApi {
    private readonly envelopeContext;
    private readonly initArgs;
    private readonly editorRef;
    af_isReact: boolean;
    af_componentId: "serverless-workflow-combined-editor";
    af_componentTitle: "Serverless Workflow Combined Editor";
    constructor(envelopeContext: KogitoEditorEnvelopeContextType<ServerlessWorkflowCombinedEditorChannelApi>, initArgs: EditorInitArgs);
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    getContent(): Promise<string>;
    getPreview(): Promise<string | undefined>;
    af_componentRoot(): JSX.Element;
    undo(): Promise<void>;
    redo(): Promise<void>;
    validate(): Promise<Notification[]>;
    setTheme(theme: EditorTheme): Promise<void>;
    colorNodes(nodeNames: string[], color: string, colorConnectedEnds: boolean): void;
    moveCursorToPosition(position: Position): void;
}
//# sourceMappingURL=ServerlessWorkflowCombinedEditorView.d.ts.map