"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timeSeriesModelFactory = exports.TIME_SERIES_MODEL = void 0;
var pmml4_4_1 = require("../../model/pmml4_4");
var LocalTransformations_1 = require("./LocalTransformations");
var MiningSchema_1 = require("./MiningSchema");
var ModelExplanation_1 = require("./ModelExplanation");
var ModelStats_1 = require("./ModelStats");
var ModelVerification_1 = require("./ModelVerification");
var Output_1 = require("./Output");
exports.TIME_SERIES_MODEL = "\nelements.elements[(name = \"TimeSeriesModel\")] ~> $map(function($v, $i) {\n  $merge([\n    $timeSeriesModelFactory(),\n    $v.attributes,\n    {\n      \"_type\": $v.name\n    },\n    {\n      ".concat(MiningSchema_1.MINING_SCHEMA, ", \n      ").concat(Output_1.OUTPUT, ",\n      ").concat(ModelStats_1.MODEL_STATS, ",\n      ").concat(ModelExplanation_1.MODEL_EXPLANATION, ",\n      ").concat(ModelVerification_1.MODEL_VERIFICATION, ",\n      ").concat(LocalTransformations_1.LOCAL_TRANSFORMATIONS, "\n    }\n  ])\n})");
function timeSeriesModelFactory() {
    return new pmml4_4_1.TimeSeriesModel({
        MiningSchema: new pmml4_4_1.MiningSchema({ MiningField: [] }),
        functionName: "regression",
        bestFit: "ARIMA",
    });
}
exports.timeSeriesModelFactory = timeSeriesModelFactory;
//# sourceMappingURL=TimeSeriesModel.js.map