"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sequenceModelFactory = exports.SEQUENCE_MODEL = void 0;
var pmml4_4_1 = require("../../model/pmml4_4");
var LocalTransformations_1 = require("./LocalTransformations");
var MiningSchema_1 = require("./MiningSchema");
var ModelStats_1 = require("./ModelStats");
exports.SEQUENCE_MODEL = "\nelements.elements[(name = \"SequenceModel\")] ~> $map(function($v, $i) {\n  $merge([\n    $sequenceModelFactory(),\n    $v.attributes,\n    {\n      \"_type\": $v.name\n    },\n    {\n      ".concat(MiningSchema_1.MINING_SCHEMA, ", \n      ").concat(ModelStats_1.MODEL_STATS, ",\n      ").concat(LocalTransformations_1.LOCAL_TRANSFORMATIONS, "\n    }\n  ])\n})");
function sequenceModelFactory() {
    return new pmml4_4_1.SequenceModel({
        MiningSchema: new pmml4_4_1.MiningSchema({ MiningField: [] }),
        Sequence: [],
        minimumConfidence: 0,
        minimumSupport: 0,
        numberOfItems: 0,
        numberOfRules: 0,
        numberOfSequences: 0,
        numberOfSets: 0,
        functionName: "regression",
    });
}
exports.sequenceModelFactory = sequenceModelFactory;
//# sourceMappingURL=SequenceModel.js.map