import React, { useEffect } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { EmbeddedWorkflowDetails } from "@kie-tools/runtime-tools-swf-enveloped-components/dist/workflowDetails/embedded";
import { useWorkflowDetailsGatewayApi } from "../WorkflowDetails";
export const WorkflowDetailsContainer = ({ workflowInstance, onOpenWorkflowInstanceDetails, ouiaId, ouiaSafe, targetOrigin, }) => {
    const gatewayApi = useWorkflowDetailsGatewayApi();
    useEffect(() => {
        const unSubscribeHandler = gatewayApi.onOpenWorkflowInstanceDetailsListener({
            onOpen(id) {
                onOpenWorkflowInstanceDetails(id);
            },
        });
        return () => {
            unSubscribeHandler.unSubscribe();
        };
    }, [onOpenWorkflowInstanceDetails, gatewayApi]);
    return (React.createElement(EmbeddedWorkflowDetails, Object.assign({}, componentOuiaProps(ouiaId, "workflow-list-container", ouiaSafe), { driver: gatewayApi, targetOrigin: targetOrigin || window.location.origin, workflowInstance: workflowInstance })));
};
//# sourceMappingURL=WorkflowDetailsContainer.js.map