"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildXmlQName = exports.parseXmlQName = void 0;
function parseXmlQName(qName) {
    var split = qName.split(":");
    if (split.length <= 1) {
        return { type: "xml-qname", localPart: qName };
    }
    if (split.length > 2) {
        throw new Error("XML QNames can't have colons (:) on neither the prefix or the localPart. Alledged QName: '".concat(qName, "'"));
    }
    return { type: "xml-qname", prefix: split[0], localPart: split[1] };
}
exports.parseXmlQName = parseXmlQName;
function buildXmlQName(_a) {
    var prefix = _a.prefix, localPart = _a.localPart;
    return prefix ? "".concat(prefix, ":").concat(localPart) : localPart;
}
exports.buildXmlQName = buildXmlQName;
//# sourceMappingURL=qNames.js.map