import { VariableContext } from "./VariableContext";
import { DMN15__tDefinitions } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import { Expression } from "./VariableOccurrence";
import { DmnLatestModel } from "@kie-tools/dmn-marshaller";
export declare type DmnDefinitions = DMN15__tDefinitions;
export declare class VariablesRepository {
    private readonly variablesIndexedByUuid;
    private readonly expressionsIndexedByUuid;
    private readonly dataTypes;
    private currentVariablePrefix;
    private currentUuidPrefix;
    constructor(dmnDefinitions: DmnDefinitions, externalDefinitions: Map<string, DmnLatestModel>);
    get variables(): Map<string, VariableContext>;
    updateVariableType(variableUuid: string, newType: string): void;
    get expressions(): Map<string, Expression>;
    renameVariable(variableUuid: string, newName: string): void;
    addVariableToContext(variableUuid: string, variableName: string, parentUuid: string, childUuid?: string): void;
    removeVariable(variableUuid: string, removeChildren?: boolean): void;
    private createDataTypes;
    private createVariables;
    private createVariablesFromInputData;
    private createVariablesFromDecisionService;
    private createVariablesFromBkm;
    private createVariablesFromDecision;
    private addVariable;
    private createVariableNode;
    private getTypeRef;
    private createDataType;
    private createInnerType;
    private buildProperties;
    private addLiteralExpression;
    private addInvocation;
    private addContext;
    private addContextEntry;
    private addFunctionDefinition;
    private addRelation;
    private addList;
    private addConditional;
    private addIterable;
    private addFor;
    private addFilterVariable;
    private addIteratorVariable;
    private addFilter;
    private addInnerExpression;
    private addInputVariable;
    private addInputVariableFromKnowledge;
    private buildVariableUuid;
    private buildName;
    private loadVariables;
    private loadImportedVariables;
}
//# sourceMappingURL=VariablesRepository.d.ts.map