import axios from "axios";
export class TaskFormGatewayApiImpl {
    constructor(getCurrentUser) {
        this.getCurrentUser = getCurrentUser;
    }
    doSubmit(userTask, phase, payload) {
        return new Promise((resolve, reject) => {
            const endpoint = `${userTask.endpoint}?phase=${phase}&${getTaskEndpointSecurityParams(this.getCurrentUser())}`;
            axios
                .post(endpoint, payload, {
                headers: {
                    "Content-Type": "application/json",
                    Accept: "application/json",
                },
            })
                .then((response) => {
                if (response.status == 200) {
                    resolve(response.data);
                }
                else {
                    reject(response);
                }
            })
                .catch((error) => reject(error));
        });
    }
    getTaskFormSchema(userTask) {
        return new Promise((resolve, reject) => {
            const endpoint = getTaskSchemaEndPoint(userTask, this.getCurrentUser());
            axios
                .get(endpoint, {
                headers: {
                    "Content-Type": "application/json",
                    Accept: "application/json",
                },
            })
                .then((response) => {
                if (response.status == 200) {
                    resolve(response.data);
                }
                else {
                    reject(response);
                }
            })
                .catch((error) => reject(error));
        });
    }
    getCustomForm(userTask) {
        return Promise.reject();
    }
}
function getTaskSchemaEndPoint(task, user) {
    let params = "";
    let endpoint = task.endpoint;
    if (task.completed) {
        endpoint = endpoint.slice(0, -(task.id.length + 1));
        endpoint = endpoint.replace(task.processInstanceId + "/", "");
    }
    else {
        params = `?${getTaskEndpointSecurityParams(user)}`;
    }
    return `${endpoint}/schema${params}`;
}
function getTaskEndpointSecurityParams(user) {
    let groups = "";
    if (user.groups && user.groups.length > 0) {
        groups = `&group=${user.groups.join("&group=")}`;
    }
    return `user=${user.id}${groups}`;
}
//# sourceMappingURL=TaskFormGatewayApi.js.map