var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { handleProcessAbort, handleProcessSkip, handleProcessRetry, jobCancel, handleJobReschedule, handleNodeTrigger, handleProcessVariableUpdate, handleNodeInstanceCancel, handleNodeInstanceRetrigger, getProcessDetails, getJobs, getSVG, getTriggerableNodes, } from "@kie-tools/runtime-tools-process-gateway-api/dist/gatewayApi";
export class GraphQLProcessDetailsQueries {
    constructor(client) {
        this.client = client;
    }
    getProcessDetails(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return getProcessDetails(id, this.client);
        });
    }
    getJobs(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return Promise.resolve(getJobs(id, this.client));
        });
    }
    handleProcessSkip(processInstance) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleProcessSkip(processInstance, this.client);
        });
    }
    handleProcessAbort(processInstance) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleProcessAbort(processInstance, this.client);
        });
    }
    handleProcessRetry(processInstance) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleProcessRetry(processInstance, this.client);
        });
    }
    getSVG(processInstance) {
        return __awaiter(this, void 0, void 0, function* () {
            return Promise.resolve(getSVG(processInstance, this.client));
        });
    }
    jobCancel(job) {
        return __awaiter(this, void 0, void 0, function* () {
            return jobCancel(job, this.client);
        });
    }
    rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleJobReschedule(job, repeatInterval, repeatLimit, scheduleDate, this.client);
        });
    }
    getTriggerableNodes(processInstance) {
        return __awaiter(this, void 0, void 0, function* () {
            return Promise.resolve(getTriggerableNodes(processInstance, this.client));
        });
    }
    handleNodeTrigger(processInstance, node) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleNodeTrigger(processInstance, node, this.client);
        });
    }
    handleNodeInstanceCancel(processInstance, node) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleNodeInstanceCancel(processInstance, node, this.client);
        });
    }
    handleProcessVariableUpdate(processInstance, updateJson) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleProcessVariableUpdate(processInstance, updateJson, this.client);
        });
    }
    handleNodeInstanceRetrigger(processInstance, node) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleNodeInstanceRetrigger(processInstance, node, this.client);
        });
    }
}
//# sourceMappingURL=ProcessDetailsQueries.js.map