var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Card } from "@patternfly/react-core/dist/js/components/Card";
import { Drawer, DrawerContent, DrawerContentBody, DrawerHead, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { Tab, Tabs, TabTitleText } from "@patternfly/react-core/dist/js/components/Tabs";
import isEmpty from "lodash/isEmpty";
import React, { useEffect, useRef, useState } from "react";
import FormDisplayerContainer from "../../containers/FormDisplayerContainer/FormDisplayerContainer";
import FormEditor from "../FormEditor/FormEditor";
const FormDetails = ({ isEnvelopeConnectedToChannel, driver, formData, ouiaId, ouiaSafe, targetOrigin, }) => {
    const [activeTab, setActiveTab] = useState(0);
    const [formContent, setFormContent] = useState({});
    const [error, setError] = useState(null);
    const [isLoading, setIsLoading] = useState(true);
    const editorResize = useRef({});
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            init();
        }
    }, [isEnvelopeConnectedToChannel]);
    const init = () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            if (formData) {
                const response = yield driver.getFormContent(formData.name);
                setFormContent(response);
                setIsLoading(false);
            }
        }
        catch (error) {
            setError(error);
        }
    });
    const saveForm = (form) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            setFormContent(form);
            yield driver.saveFormContent(formData.name, {
                configuration: form.configuration,
                source: form.source,
            });
        }
        catch (error) {
            setError(error);
        }
    });
    const panelContent = (React.createElement(DrawerPanelContent, { isResizable: true, defaultSize: "800px", onResize: () => {
            var _a;
            (_a = editorResize === null || editorResize === void 0 ? void 0 : editorResize.current) === null || _a === void 0 ? void 0 : _a.doResize();
        } },
        React.createElement(DrawerHead, { style: { height: "100%" } }, formContent && Object.keys(formContent)[0] && Object.keys(formContent)[0].length > 0 && (React.createElement("span", null,
            React.createElement(FormDisplayerContainer, { formContent: formContent, targetOrigin: targetOrigin }))))));
    const onTabSelect = (_event, tabIndex) => {
        setActiveTab(tabIndex);
    };
    const getSource = () => {
        var _a;
        if (!isEmpty(formContent)) {
            return (_a = formContent === null || formContent === void 0 ? void 0 : formContent.source) !== null && _a !== void 0 ? _a : "";
        }
        return "";
    };
    const getType = () => {
        if (!isEmpty(formData)) {
            return formData.type;
        }
        return "";
    };
    const getConfig = () => {
        if (!isEmpty(formContent)) {
            return JSON.stringify(formContent === null || formContent === void 0 ? void 0 : formContent.configuration.resources, null, 2);
        }
        return "";
    };
    if (error) {
        return React.createElement(ServerErrors, { error: error, variant: "large" });
    }
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "form-details", ouiaSafe)), !isLoading ? (React.createElement(Drawer, { isStatic: true },
        React.createElement(DrawerContent, { panelContent: panelContent },
            React.createElement(Tabs, { isFilled: true, activeKey: activeTab, onSelect: onTabSelect },
                React.createElement(Tab, { eventKey: 0, title: React.createElement(TabTitleText, null, "Source"), id: "source-tab", "aria-labelledby": "source-tab" },
                    React.createElement(DrawerContentBody, { style: {
                            padding: "0px",
                            background: "var(--pf-c-page__main-section--BackgroundColor)",
                        } }, activeTab === 0 && (React.createElement(FormEditor, { code: getSource(), formContent: formContent, setFormContent: setFormContent, saveFormContent: saveForm, isSource: true, formType: getType(), ref: editorResize })))),
                React.createElement(Tab, { eventKey: 1, title: React.createElement(TabTitleText, null, "Connections"), id: "config-tab", "aria-labelledby": "config-tab" },
                    React.createElement(DrawerContentBody, { style: {
                            padding: "0px",
                            background: "var(--pf-c-page__main-section--BackgroundColor)",
                        } }, activeTab === 1 && (React.createElement(FormEditor, { code: getConfig(), formContent: formContent, setFormContent: setFormContent, saveFormContent: saveForm, isConfig: true, ref: editorResize })))))))) : (React.createElement(Card, null,
        React.createElement(KogitoSpinner, { spinnerText: "Loading form ..." })))));
};
export default FormDetails;
//# sourceMappingURL=FormDetails.js.map