import React from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { TextVariants, Text } from "@patternfly/react-core/dist/js/components/Text";
import { Card, CardBody, CardHeaderMain, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { FormGroup, Form } from "@patternfly/react-core/dist/js/components/Form";
import Moment from "react-moment";
const CustomDashboardCard = ({ customDashboardData, driver, ouiaId, ouiaSafe, }) => {
    const handleCardClick = () => {
        driver.openDashboard(customDashboardData);
    };
    return (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId, "customDashboard-card", ouiaSafe), { isSelectable: true, onClick: handleCardClick, "data-testid": "card" }),
        React.createElement(CardHeader, null,
            React.createElement(CardHeaderMain, null, "Empty")),
        React.createElement(CardHeader, null,
            React.createElement(Text, { component: TextVariants.h1, className: "pf-u-font-weight-bold" }, customDashboardData.name)),
        React.createElement(CardBody, null,
            React.createElement("div", { className: "pf-u-mt-md" },
                React.createElement(Form, null,
                    React.createElement(FormGroup, { label: "Path", fieldId: "path" },
                        React.createElement(Text, { component: TextVariants.p }, customDashboardData.path)),
                    React.createElement(FormGroup, { label: "LastModified", fieldId: "lastModified" },
                        React.createElement(Text, { component: TextVariants.p },
                            React.createElement(Moment, { fromNow: true }, customDashboardData.lastModified))))))));
};
export default CustomDashboardCard;
//# sourceMappingURL=CustomDashboardCard.js.map