import { Specification } from "@severlessworkflow/sdk-typescript";
import * as jsonc from "jsonc-parser";
export declare function getFunctions(rootNode: jsonc.Node): {
    sourceModel?: any | undefined;
    name: string;
    type?: "rest" | "asyncapi" | "rpc" | "graphql" | "odata" | "expression" | "custom" | undefined;
    metadata?: {
        [x: string]: string;
        [x: number]: string;
    } | undefined;
    operation: string;
    authRef?: string | undefined;
}[];
export declare function getEvents(rootNode: jsonc.Node): {
    sourceModel?: any | undefined;
    name?: string | undefined;
    source?: string | undefined;
    type?: string | undefined;
    kind?: "consumed" | "produced" | undefined;
    correlation?: {
        [x: number]: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        };
        [Symbol.iterator]: () => IterableIterator<{
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }>;
        [Symbol.unscopables]: () => {
            copyWithin: boolean;
            entries: boolean;
            fill: boolean;
            find: boolean;
            findIndex: boolean;
            keys: boolean;
            values: boolean;
        };
        0: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        };
        length: number;
        toString: () => string;
        toLocaleString: () => string;
        pop: () => {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        } | undefined;
        push: (...items: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[]) => number;
        concat: {
            (...items: ConcatArray<{
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }>[]): {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[];
            (...items: ({
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            } | ConcatArray<{
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }>)[]): {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[];
        };
        join: (separator?: string | undefined) => string;
        reverse: () => {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[];
        shift: () => {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        } | undefined;
        slice: (start?: number | undefined, end?: number | undefined) => {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[];
        sort: (compareFn?: ((a: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, b: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }) => number) | undefined) => [{
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, ...{
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[]];
        splice: {
            (start: number, deleteCount?: number | undefined): {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[];
            (start: number, deleteCount: number, ...items: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]): {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[];
        };
        unshift: (...items: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[]) => number;
        indexOf: (searchElement: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, fromIndex?: number | undefined) => number;
        lastIndexOf: (searchElement: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, fromIndex?: number | undefined) => number;
        every: {
            <S extends {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }>(predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, index: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => value is S, thisArg?: any): this is S[];
            (predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, index: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => unknown, thisArg?: any): boolean;
        };
        some: (predicate: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, index: number, array: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[]) => unknown, thisArg?: any) => boolean;
        forEach: (callbackfn: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, index: number, array: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[]) => void, thisArg?: any) => void;
        map: <U>(callbackfn: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, index: number, array: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[]) => U, thisArg?: any) => U[];
        filter: {
            <S_1 extends {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }>(predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, index: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => value is S_1, thisArg?: any): S_1[];
            (predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, index: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => unknown, thisArg?: any): {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[];
        };
        reduce: {
            (callbackfn: (previousValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }): {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            };
            (callbackfn: (previousValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, initialValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }): {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            };
            <U_1>(callbackfn: (previousValue: U_1, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => U_1, initialValue: U_1): U_1;
        };
        reduceRight: {
            (callbackfn: (previousValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }): {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            };
            (callbackfn: (previousValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, initialValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }): {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            };
            <U_2>(callbackfn: (previousValue: U_2, currentValue: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, currentIndex: number, array: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => U_2, initialValue: U_2): U_2;
        };
        find: {
            <S_2 extends {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }>(predicate: (this: void, value: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, index: number, obj: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => value is S_2, thisArg?: any): S_2 | undefined;
            (predicate: (value: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }, index: number, obj: {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            }[]) => unknown, thisArg?: any): {
                contextAttributeName: string;
                contextAttributeValue?: string | undefined;
            } | undefined;
        };
        findIndex: (predicate: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, index: number, obj: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[]) => unknown, thisArg?: any) => number;
        fill: (value: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, start?: number | undefined, end?: number | undefined) => [{
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, ...{
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[]];
        copyWithin: (target: number, start: number, end?: number | undefined) => [{
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, ...{
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[]];
        entries: () => IterableIterator<[number, {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }]>;
        keys: () => IterableIterator<number>;
        values: () => IterableIterator<{
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }>;
        includes: (searchElement: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, fromIndex?: number | undefined) => boolean;
        flatMap: <U_3, This = undefined>(callback: (this: This, value: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }, index: number, array: {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        }[]) => U_3 | readonly U_3[], thisArg?: This | undefined) => U_3[];
        flat: <A, D extends number = 1>(this: A, depth?: D | undefined) => FlatArray<A, D>[];
        at: (index: number) => {
            contextAttributeName: string;
            contextAttributeValue?: string | undefined;
        } | undefined;
    } | undefined;
    dataOnly?: boolean | undefined;
    metadata?: {
        [x: string]: string;
        [x: number]: string;
    } | undefined;
}[];
export declare function getStates(rootNode: jsonc.Node): Specification.States;
//# sourceMappingURL=modelQueries.d.ts.map