import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useRef } from "react";
import { Unitables } from "./Unitables";
import { UnitablesContextProvider } from "./UnitablesContextProvider";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { ExclamationIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-icon";
import { Text, TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { ErrorBoundary } from "@kie-tools/dmn-runner/dist/ErrorBoundary";
export function UnitablesWrapper(props) {
    const inputErrorBoundaryRef = useRef(null);
    useEffect(() => {
        var _a;
        (_a = inputErrorBoundaryRef.current) === null || _a === void 0 ? void 0 : _a.reset();
    }, [props.jsonSchemaBridge]);
    return (_jsx(UnitablesContextProvider, Object.assign({ rowsInputs: props.rows }, { children: props.error ? (_jsx(InputError, {})) : (_jsx(ErrorBoundary, Object.assign({ ref: inputErrorBoundaryRef, setHasError: props.setError, error: _jsx(InputError, {}) }, { children: _jsx(Unitables, Object.assign({}, props)) }))) })));
}
function InputError() {
    return (_jsx("div", Object.assign({ style: { width: "50vw" } }, { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: ExclamationIcon }), _jsx(TextContent, { children: _jsx(Text, Object.assign({ component: "h2" }, { children: "Error" })) }), _jsx(EmptyStateBody, { children: _jsx("p", { children: "An error has happened while trying to show your inputs" }) })] }) })));
}
//# sourceMappingURL=UnitablesWrapper.js.map