export class NavigationKeysUtils {
    static isBackspace(key) {
        return /^backspace$/i.test(key);
    }
    static isDelete(key) {
        return /^delete$/i.test(key);
    }
    static isEsc(key) {
        return /^escape$/i.test(key);
    }
    static isAltGraph(key) {
        return /^altgraph$/i.test(key);
    }
    static isArrowDown(key) {
        return /^arrowdown$/i.test(key);
    }
    static isArrowLeft(key) {
        return /^arrowleft$/i.test(key);
    }
    static isArrowRight(key) {
        return /^arrowright$/i.test(key);
    }
    static isArrowUp(key) {
        return /^arrowup$/i.test(key);
    }
    static isAnyArrow(key) {
        return /^arrow(up|right|down|left)$/i.test(key);
    }
    static isEnter(key) {
        return /^enter$/i.test(key);
    }
    static isTab(key) {
        return /^tab$/i.test(key);
    }
    static isFunctionKey(key) {
        return /^F\d{1,2}$/i.test(key);
    }
}
//# sourceMappingURL=keyUtils.js.map