import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import { BeeTableHeaderVisibility, BeeTableOperation, DmnBuiltInDataType, } from "../../api";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { useNestedExpressionContainerWithNestedExpressions } from "../../resizing/Hooks";
import { NestedExpressionContainerContext } from "../../resizing/NestedExpressionContainerContext";
import { LIST_EXPRESSION_EXTRA_WIDTH, LIST_EXPRESSION_ITEM_MIN_WIDTH } from "../../resizing/WidthConstants";
import { BeeTable } from "../../table/BeeTable";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { ListItemCell } from "./ListItemCell";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { findAllIdsDeep } from "../../ids/ids";
import "./ListExpression.css";
export function ListExpression({ isNested, parentElementId, expression: listExpression, }) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { setExpression, setWidthsById } = useBoxedExpressionEditorDispatch();
    const { expressionHolderId, widthsById } = useBoxedExpressionEditor();
    const { nestedExpressionContainerValue, onColumnResizingWidthChange } = useNestedExpressionContainerWithNestedExpressions(useMemo(() => {
        var _a;
        const nestedExpressions = (_a = listExpression.expression) !== null && _a !== void 0 ? _a : [];
        return {
            nestedExpressions: nestedExpressions,
            fixedColumnActualWidth: 0,
            fixedColumnResizingWidth: { value: 0, isPivoting: false },
            fixedColumnMinWidth: 0,
            nestedExpressionMinWidth: LIST_EXPRESSION_ITEM_MIN_WIDTH,
            extraWidth: LIST_EXPRESSION_EXTRA_WIDTH,
            expression: listExpression,
            flexibleColumnIndex: 1,
            widthsById: widthsById,
        };
    }, [listExpression, widthsById]));
    const beeTableOperationConfig = useMemo(() => [
        {
            group: i18n.rows,
            items: [
                { name: i18n.rowOperations.reset, type: BeeTableOperation.RowReset },
                { name: i18n.rowOperations.insertAbove, type: BeeTableOperation.RowInsertAbove },
                { name: i18n.rowOperations.insertBelow, type: BeeTableOperation.RowInsertBelow },
                { name: i18n.insert, type: BeeTableOperation.RowInsertN },
                { name: i18n.rowOperations.delete, type: BeeTableOperation.RowDelete },
            ],
        },
        {
            group: i18n.terms.selection.toUpperCase(),
            items: [
                { name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy },
                { name: i18n.terms.cut, type: BeeTableOperation.SelectionCut },
                { name: i18n.terms.paste, type: BeeTableOperation.SelectionPaste },
                { name: i18n.terms.reset, type: BeeTableOperation.SelectionReset },
            ],
        },
    ], [i18n]);
    const beeTableRows = useMemo(() => {
        var _a;
        const rows = ((_a = listExpression.expression) !== null && _a !== void 0 ? _a : []).map((item) => ({
            expression: item,
        }));
        if (rows.length === 0) {
            rows.push({
                expression: undefined,
            });
        }
        return rows;
    }, [listExpression.expression]);
    const beeTableColumns = useMemo(() => {
        var _a, _b;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = listExpression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                dataType: (_b = listExpression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                isRowIndexColumn: false,
                minWidth: LIST_EXPRESSION_ITEM_MIN_WIDTH,
                width: undefined,
            },
        ];
    }, [expressionHolderId, listExpression]);
    const getRowKey = useCallback((row) => {
        return row.id;
    }, []);
    const cellComponentByColumnAccessor = useMemo(() => ({
        [expressionHolderId]: (props) => (_jsx(ListItemCell, Object.assign({ parentElementId: parentElementId, listExpression: listExpression }, props))),
    }), [expressionHolderId, listExpression, parentElementId]);
    const onRowAdded = useCallback((args) => {
        setExpression((prev) => {
            var _a;
            const newItems = [...((_a = prev.expression) !== null && _a !== void 0 ? _a : [])];
            const newListItems = [];
            for (let i = 0; i < args.rowsCount; i++) {
                newListItems.push(undefined);
            }
            for (const newEntry of newListItems) {
                newItems.splice(args.beforeIndex, 0, newEntry);
            }
            const ret = Object.assign(Object.assign({}, prev), { expression: newItems });
            return ret;
        });
    }, [setExpression]);
    const onRowDeleted = useCallback((args) => {
        let oldExpression;
        setExpression((prev) => {
            var _a;
            const newItems = [...((_a = prev.expression) !== null && _a !== void 0 ? _a : [])];
            oldExpression = newItems[args.rowIndex];
            newItems.splice(args.rowIndex, 1);
            const ret = Object.assign(Object.assign({}, prev), { expression: newItems });
            return ret;
        });
        setWidthsById(({ newMap }) => {
            for (const id of findAllIdsDeep(oldExpression)) {
                newMap.delete(id);
            }
        });
    }, [setExpression, setWidthsById]);
    const onRowReset = useCallback((args) => {
        let oldExpression;
        setExpression((prev) => {
            var _a;
            const newItems = [...((_a = prev.expression) !== null && _a !== void 0 ? _a : [])];
            oldExpression = newItems[args.rowIndex];
            newItems.splice(args.rowIndex, 1, undefined);
            const ret = Object.assign(Object.assign({}, prev), { expression: newItems });
            return ret;
        });
        setWidthsById(({ newMap }) => {
            for (const id of findAllIdsDeep(oldExpression)) {
                newMap.delete(id);
            }
        });
    }, [setExpression, setWidthsById]);
    const beeTableHeaderVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.None : BeeTableHeaderVisibility.AllLevels;
    }, [isNested]);
    const onColumnUpdates = useCallback(([{ name, typeRef }]) => {
        setExpression((prev) => {
            const ret = Object.assign(Object.assign({}, prev), { "@_label": name, "@_typeRef": typeRef });
            return ret;
        });
    }, [setExpression]);
    const allowedOperations = useCallback((conditions) => {
        if (!conditions.selection.selectionStart || !conditions.selection.selectionEnd) {
            return [];
        }
        return [
            BeeTableOperation.SelectionCopy,
            ...(conditions.selection.selectionStart.rowIndex >= 0
                ? [
                    BeeTableOperation.RowInsertAbove,
                    BeeTableOperation.RowInsertBelow,
                    BeeTableOperation.RowInsertN,
                    ...(beeTableRows.length > 1 ? [BeeTableOperation.RowDelete] : []),
                    BeeTableOperation.RowReset,
                ]
                : []),
        ];
    }, [beeTableRows.length]);
    return (_jsx(NestedExpressionContainerContext.Provider, Object.assign({ value: nestedExpressionContainerValue }, { children: _jsx("div", Object.assign({ className: `${listExpression["@_id"]} list-expression` }, { children: _jsx(BeeTable, { onColumnResizingWidthChange: onColumnResizingWidthChange, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, tableId: listExpression["@_id"], headerVisibility: beeTableHeaderVisibility, cellComponentByColumnAccessor: cellComponentByColumnAccessor, columns: beeTableColumns, rows: beeTableRows, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, getRowKey: getRowKey, onRowAdded: onRowAdded, onRowDeleted: onRowDeleted, onRowReset: onRowReset, onColumnUpdates: onColumnUpdates, shouldRenderRowIndexColumn: true, shouldShowRowsInlineControls: true, shouldShowColumnsInlineControls: false }) })) })));
}
//# sourceMappingURL=ListExpression.js.map