import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import * as React from "react";
import { useCallback, useEffect, useMemo } from "react";
import { BeeTableHeaderVisibility, BeeTableOperation, BoxedFunctionKind, DmnBuiltInDataType, generateUuid, } from "../../api";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { usePublishedBeeTableResizableColumns } from "../../resizing/BeeTableResizableColumnsContext";
import { useApportionedColumnWidthsIfNestedTable } from "../../resizing/Hooks";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { PMML_FUNCTION_EXPRESSION_EXTRA_WIDTH, PMML_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH, PMML_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH, } from "../../resizing/WidthConstants";
import { useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
import { BeeTable } from "../../table/BeeTable";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { useFunctionExpressionControllerCell, useFunctionExpressionParametersColumnHeader } from "./FunctionExpression";
import "./PmmlFunctionExpression.css";
export function PmmlFunctionExpression({ functionExpression, isNested, parentElementId, }) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { expressionHolderId } = useBoxedExpressionEditor();
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const parametersColumnHeader = useFunctionExpressionParametersColumnHeader(functionExpression.formalParameter);
    const parametersId = useMemo(() => (functionExpression["@_id"] ? `${functionExpression["@_id"]}-parameters` : "parameters"), [functionExpression]);
    const beeTableColumns = useMemo(() => {
        var _a, _b;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = functionExpression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                dataType: (_b = functionExpression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                isRowIndexColumn: false,
                width: undefined,
                columns: [
                    {
                        headerCellElement: parametersColumnHeader,
                        accessor: parametersId,
                        label: "parameters",
                        isRowIndexColumn: false,
                        dataType: undefined,
                        width: undefined,
                        columns: [
                            {
                                label: "label",
                                accessor: "label",
                                dataType: undefined,
                                isRowIndexColumn: false,
                                isWidthPinned: true,
                                isWidthConstant: true,
                                width: PMML_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH,
                                minWidth: PMML_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH,
                            },
                            {
                                label: "value",
                                accessor: "value",
                                dataType: undefined,
                                isRowIndexColumn: false,
                                isWidthConstant: true,
                                width: PMML_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH,
                                minWidth: PMML_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH,
                            },
                        ],
                    },
                ],
            },
        ];
    }, [expressionHolderId, functionExpression, parametersColumnHeader, parametersId]);
    const headerVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.SecondToLastLevel : BeeTableHeaderVisibility.AllLevels;
    }, [isNested]);
    const onColumnUpdates = useCallback(([{ name, typeRef: dataType }]) => {
        setExpression((prev) => {
            const ret = Object.assign(Object.assign({}, prev), { "@_label": name, "@_typeRef": dataType });
            return ret;
        });
    }, [setExpression]);
    const beeTableOperationConfig = useMemo(() => {
        return [
            {
                group: i18n.terms.selection.toUpperCase(),
                items: [{ name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy }],
            },
            {
                group: i18n.function.toUpperCase(),
                items: [{ name: i18n.rowOperations.reset, type: BeeTableOperation.RowReset }],
            },
        ];
    }, [i18n]);
    const getDocument = useCallback(() => {
        var _a;
        return (_a = functionExpression.expression.contextEntry) === null || _a === void 0 ? void 0 : _a.find(({ variable }) => (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === "document");
    }, [functionExpression.expression]);
    const getModel = useCallback(() => {
        var _a;
        return (_a = functionExpression.expression.contextEntry) === null || _a === void 0 ? void 0 : _a.find(({ variable }) => (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === "model");
    }, [functionExpression.expression]);
    const beeTableRows = useMemo(() => {
        var _a, _b, _c, _d, _e, _f;
        const document = getDocument();
        const model = getModel();
        return [
            {
                label: "Document",
                value: (_c = (_b = (_a = document === null || document === void 0 ? void 0 : document.expression) === null || _a === void 0 ? void 0 : _a.text) === null || _b === void 0 ? void 0 : _b.__$$text.replaceAll(`"`, ``)) !== null && _c !== void 0 ? _c : "",
                pmmlFunctionExpression: functionExpression,
            },
            {
                label: "Model",
                value: (_f = (_e = (_d = model === null || model === void 0 ? void 0 : model.expression) === null || _d === void 0 ? void 0 : _d.text) === null || _e === void 0 ? void 0 : _e.__$$text.replaceAll(`"`, ``)) !== null && _f !== void 0 ? _f : "",
                pmmlFunctionExpression: functionExpression,
            },
        ];
    }, [functionExpression, getDocument, getModel]);
    const controllerCell = useFunctionExpressionControllerCell(BoxedFunctionKind.Pmml);
    const getRowKey = useCallback((r) => {
        return r.id;
    }, []);
    const onRowReset = useCallback(() => {
        setExpression((prev) => {
            const ret = Object.assign(Object.assign({}, prev), { expression: undefined });
            return ret;
        });
    }, [setExpression]);
    const cellComponentByColumnAccessor = useMemo(() => ({
        label: (props) => _jsx(PmmlFunctionExpressionLabelCell, Object.assign({}, props)),
        value: (props) => _jsx(PmmlFunctionExpressionValueCell, Object.assign({}, props)),
    }), []);
    const columns = useMemo(() => [
        {
            minWidth: PMML_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH,
            width: PMML_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH,
            isFrozen: true,
        },
        {
            minWidth: PMML_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH,
            width: PMML_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH,
        },
    ], []);
    const { onColumnResizingWidthChange, isPivoting, columnResizingWidths } = usePublishedBeeTableResizableColumns(functionExpression["@_id"], columns.length, true);
    const beeTableRef = React.useRef(null);
    useApportionedColumnWidthsIfNestedTable(beeTableRef, isPivoting, isNested, PMML_FUNCTION_EXPRESSION_EXTRA_WIDTH, columns, columnResizingWidths, useMemo(() => [], []));
    const allowedOperations = useCallback((conditions) => {
        return [BeeTableOperation.SelectionCopy];
    }, []);
    return (_jsx("div", Object.assign({ className: `function-expression ${functionExpression["@_id"]}` }, { children: _jsx(BeeTable, { forwardRef: beeTableRef, onColumnResizingWidthChange: onColumnResizingWidthChange, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, onColumnUpdates: onColumnUpdates, getRowKey: getRowKey, onRowReset: onRowReset, columns: beeTableColumns, rows: beeTableRows, headerLevelCountForAppendingRowIndexColumn: 2, skipLastHeaderGroup: true, cellComponentByColumnAccessor: cellComponentByColumnAccessor, headerVisibility: headerVisibility, controllerCell: controllerCell, shouldRenderRowIndexColumn: true, shouldShowRowsInlineControls: false, shouldShowColumnsInlineControls: false }) })));
}
const PMML_BINDING_VALUE_PLACEHOLDER = "-- None selected --";
function PmmlFunctionExpressionLabelCell(props) {
    const label = useMemo(() => {
        return props.data[props.rowIndex].label;
    }, [props.data, props.rowIndex]);
    const { isActive } = useBeeTableSelectableCellRef(props.rowIndex, props.columnIndex, undefined, useCallback(() => label, [label]));
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject("");
        }
    }, [beeGwtService, isActive]);
    return (_jsxs("div", Object.assign({ className: "pmml-function-expression-label" }, { children: [_jsx("div", Object.assign({ className: "name" }, { children: label })), _jsx("div", Object.assign({ className: "data-type" }, { children: `(string)` }))] })));
}
function PmmlFunctionExpressionValueCell(props) {
    return props.rowIndex === 0 ? (_jsx(PmmlFunctionExpressionDocumentCell, Object.assign({}, props))) : (_jsx(PmmlFunctionExpressionModelCell, Object.assign({}, props)));
}
function getDocumentEntry(pmmlFunction) {
    var _a, _b;
    return ((_b = (_a = pmmlFunction.expression.contextEntry) === null || _a === void 0 ? void 0 : _a.find(({ variable }) => (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === "document")) !== null && _b !== void 0 ? _b : {
        "@_id": generateUuid(),
        expression: {
            "@_id": generateUuid(),
            __$$element: "literalExpression",
        },
    });
}
function getModelEntry(pmmlFunction) {
    var _a, _b;
    return ((_b = (_a = pmmlFunction.expression.contextEntry) === null || _a === void 0 ? void 0 : _a.find(({ variable }) => (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === "model")) !== null && _b !== void 0 ? _b : {
        "@_id": generateUuid(),
        expression: {
            "@_id": generateUuid(),
            __$$element: "literalExpression",
        },
    });
}
function getUpdatedExpression(prev, newDocument, newModel) {
    const document = getDocumentEntry(prev);
    const model = getModelEntry(prev);
    const ret = Object.assign(Object.assign({}, prev), { expression: Object.assign(Object.assign({ __$$element: "context" }, prev.expression), { contextEntry: [
                Object.assign(Object.assign({}, document), { variable: {
                        "@_name": "document",
                    }, expression: {
                        __$$element: "literalExpression",
                        text: { __$$text: newDocument },
                    } }),
                Object.assign(Object.assign({}, model), { variable: {
                        "@_name": "model",
                    }, expression: {
                        __$$element: "literalExpression",
                        text: { __$$text: newModel },
                    } }),
            ] }) });
    return ret;
}
function PmmlFunctionExpressionDocumentCell(props) {
    var _a;
    const pmmlFunctionExpression = useMemo(() => props.data[props.rowIndex].pmmlFunctionExpression, [props.data, props.rowIndex]);
    const { pmmlDocuments, editorRef } = useBoxedExpressionEditor();
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const contextExpression = useMemo(() => {
        var _a;
        if (((_a = pmmlFunctionExpression.expression) === null || _a === void 0 ? void 0 : _a.__$$element) === "context") {
            return pmmlFunctionExpression.expression;
        }
    }, [pmmlFunctionExpression.expression]);
    const pmmlDocument = useMemo(() => {
        var _a, _b;
        if (contextExpression) {
            const docExpression = (_a = contextExpression.contextEntry) === null || _a === void 0 ? void 0 : _a.find(({ variable }) => (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === "document");
            if ((docExpression === null || docExpression === void 0 ? void 0 : docExpression.expression.__$$element) === "literalExpression") {
                return (_b = docExpression === null || docExpression === void 0 ? void 0 : docExpression.expression.text) === null || _b === void 0 ? void 0 : _b.__$$text;
            }
        }
    }, [contextExpression]);
    const onSelect = useCallback((event, newDocument) => {
        setSelectOpen(false);
        setExpression((prev) => {
            return getUpdatedExpression(prev, newDocument, "");
        });
    }, [setExpression]);
    const [isSelectOpen, setSelectOpen] = React.useState(false);
    useBeeTableSelectableCellRef(props.rowIndex, props.columnIndex, undefined, useCallback(() => pmmlDocument !== null && pmmlDocument !== void 0 ? pmmlDocument : "", [pmmlDocument]));
    return (_jsx(Select, Object.assign({ className: `pmml-document-select`, menuAppendTo: (_a = editorRef === null || editorRef === void 0 ? void 0 : editorRef.current) !== null && _a !== void 0 ? _a : "inline", ouiaId: "pmml-document-select", placeholderText: PMML_BINDING_VALUE_PLACEHOLDER, "aria-placeholder": PMML_BINDING_VALUE_PLACEHOLDER, variant: SelectVariant.single, onToggle: setSelectOpen, onSelect: onSelect, isOpen: isSelectOpen, selections: [pmmlDocument] }, { children: (pmmlDocuments !== null && pmmlDocuments !== void 0 ? pmmlDocuments : []).map(({ document }) => (_jsx(SelectOption, Object.assign({ "data-testid": `pmml-${document}`, value: document, "data-ouia-component-id": document }, { children: document }), document))) })));
}
function PmmlFunctionExpressionModelCell(props) {
    var _a;
    const pmmlFunctionExpression = useMemo(() => props.data[props.rowIndex].pmmlFunctionExpression, [props.data, props.rowIndex]);
    const { pmmlDocuments, editorRef } = useBoxedExpressionEditor();
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onSelect = useCallback((event, newModel) => {
        setSelectOpen(false);
        setExpression((prev) => {
            var _a, _b, _c;
            const document = getDocumentEntry(prev);
            const currentDocument = ((_a = document.expression) === null || _a === void 0 ? void 0 : _a.__$$element) === "literalExpression" ? (_c = (_b = document.expression.text) === null || _b === void 0 ? void 0 : _b.__$$text) !== null && _c !== void 0 ? _c : "" : "";
            return getUpdatedExpression(prev, currentDocument, newModel);
        });
    }, [setExpression]);
    const [isSelectOpen, setSelectOpen] = React.useState(false);
    const contextExpression = useMemo(() => {
        var _a;
        if (((_a = pmmlFunctionExpression.expression) === null || _a === void 0 ? void 0 : _a.__$$element) === "context") {
            return pmmlFunctionExpression.expression;
        }
    }, [pmmlFunctionExpression.expression]);
    const pmmlDocument = useMemo(() => {
        var _a, _b;
        if (contextExpression) {
            const docExpression = (_a = contextExpression.contextEntry) === null || _a === void 0 ? void 0 : _a.find(({ variable }) => (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === "document");
            if ((docExpression === null || docExpression === void 0 ? void 0 : docExpression.expression.__$$element) === "literalExpression") {
                return (_b = docExpression === null || docExpression === void 0 ? void 0 : docExpression.expression.text) === null || _b === void 0 ? void 0 : _b.__$$text;
            }
        }
    }, [contextExpression]);
    const model = useMemo(() => {
        var _a, _b;
        if (contextExpression) {
            const modelExpression = (_a = contextExpression.contextEntry) === null || _a === void 0 ? void 0 : _a.find(({ variable }) => (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === "model");
            if ((modelExpression === null || modelExpression === void 0 ? void 0 : modelExpression.expression.__$$element) === "literalExpression") {
                return (_b = modelExpression === null || modelExpression === void 0 ? void 0 : modelExpression.expression.text) === null || _b === void 0 ? void 0 : _b.__$$text;
            }
        }
    }, [contextExpression]);
    const models = useMemo(() => (pmmlDocuments !== null && pmmlDocuments !== void 0 ? pmmlDocuments : [])
        .filter(({ document }) => document === pmmlDocument)
        .flatMap(({ modelsFromDocument }) => modelsFromDocument !== null && modelsFromDocument !== void 0 ? modelsFromDocument : []), [pmmlDocument, pmmlDocuments]);
    useBeeTableSelectableCellRef(props.rowIndex, props.columnIndex, undefined, useCallback(() => model !== null && model !== void 0 ? model : "", [model]));
    return (_jsx(Select, Object.assign({ className: `pmml-document-select`, menuAppendTo: (_a = editorRef === null || editorRef === void 0 ? void 0 : editorRef.current) !== null && _a !== void 0 ? _a : "inline", ouiaId: "pmml-document-select", isDisabled: !pmmlDocument, placeholderText: pmmlDocument ? PMML_BINDING_VALUE_PLACEHOLDER : "Select a document first", "aria-placeholder": PMML_BINDING_VALUE_PLACEHOLDER, variant: SelectVariant.single, onToggle: setSelectOpen, onSelect: onSelect, isOpen: isSelectOpen, selections: [model] }, { children: models.map(({ model }) => (_jsx(SelectOption, Object.assign({ "data-testid": `pmml-${model}`, value: model, "data-ouia-component-id": model }, { children: model }), model))) })));
}
//# sourceMappingURL=PmmlFunctionExpression.js.map