import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useEffect } from "react";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditor, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
import "./ContextEntryExpressionCell.css";
import { useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
export const ContextEntryExpressionCell = ({ data, rowIndex, columnIndex, }) => {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const { variable, expression, index } = data[rowIndex];
    const { isActive } = useBeeTableSelectableCellRef(rowIndex, columnIndex, undefined);
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(expression === null || expression === void 0 ? void 0 : expression["@_id"]);
        }
    }, [beeGwtService, columnIndex, expression, isActive]);
    const onSetExpression = useCallback(({ getNewExpression }) => {
        setExpression((prev) => {
            var _a, _b, _c, _d, _e;
            const newContextEntries = [...((_a = prev.contextEntry) !== null && _a !== void 0 ? _a : [])];
            const newExpression = getNewExpression((_c = (_b = newContextEntries[index]) === null || _b === void 0 ? void 0 : _b.expression) !== null && _c !== void 0 ? _c : undefined);
            newContextEntries[index] = Object.assign(Object.assign({}, newContextEntries[index]), { expression: newExpression, variable: Object.assign(Object.assign({}, newContextEntries[index].variable), { "@_name": (_d = newExpression === null || newExpression === void 0 ? void 0 : newExpression["@_label"]) !== null && _d !== void 0 ? _d : newContextEntries[index].variable["@_name"], "@_typeRef": (_e = newExpression === null || newExpression === void 0 ? void 0 : newExpression["@_typeRef"]) !== null && _e !== void 0 ? _e : newContextEntries[index].variable["@_typeRef"] }) });
            const ret = Object.assign(Object.assign({}, prev), { contextEntry: newContextEntries });
            return ret;
        });
    }, [index, setExpression]);
    return (_jsx(NestedExpressionDispatchContextProvider, Object.assign({ onSetExpression: onSetExpression }, { children: _jsx(ExpressionContainer, { expression: expression, isResetSupported: true, isNested: true, rowIndex: rowIndex, columnIndex: columnIndex, parentElementId: variable["@_id"], parentElementTypeRef: variable["@_typeRef"], parentElementName: variable["@_name"] }) })));
};
//# sourceMappingURL=ContextEntryExpressionCell.js.map