import * as React from "react";
import * as ReactTable from "react-table";
import { ResizerStopBehavior } from "../resizing/ResizingWidthsContext";
import { BeeTableCellUpdate, BeeTableColumnUpdate } from "../table/BeeTable";
import { BeeTableSelection } from "../selection/BeeTableSelectionContext";
export interface BeeTableCellProps<R extends object> {
    data: readonly R[];
    rowIndex: number;
    columnIndex: number;
    columnId: string;
}
export interface BeeTableProps<R extends object> {
    tableId?: string;
    additionalRow?: React.ReactElement[];
    editColumnLabel?: string | {
        [groupType: string]: string;
    };
    isEditableHeader?: boolean;
    controllerCell?: string | JSX.Element;
    rowWrapper?: React.FunctionComponent<React.PropsWithChildren<{
        row: R;
        rowIndex: number;
    }>>;
    cellComponentByColumnAccessor?: {
        [columnId: string]: React.FunctionComponent<BeeTableCellProps<R>>;
    };
    columns: ReactTable.Column<R>[];
    rows: R[];
    onCellUpdates?: (cellUpdates: BeeTableCellUpdate<R>[]) => void;
    onColumnUpdates?: (columnUpdates: BeeTableColumnUpdate<R>[]) => void;
    operationConfig?: BeeTableOperationConfig;
    allowedOperations: (conditions: BeeTableContextMenuAllowedOperationsConditions) => BeeTableOperation[];
    headerVisibility?: BeeTableHeaderVisibility;
    headerLevelCountForAppendingRowIndexColumn?: number;
    skipLastHeaderGroup?: boolean;
    getRowKey?: (row: ReactTable.Row<R>) => string;
    getColumnKey?: (column: ReactTable.ColumnInstance<R>) => string;
    onHeaderClick?: (columnKey: string) => void;
    onHeaderKeyUp?: (columnKey: string) => void;
    onDataCellClick?: (columnID: string) => void;
    onDataCellKeyUp?: (columnID: string) => void;
    isReadOnly?: boolean;
    enableKeyboardNavigation?: boolean;
    onRowAdded?: (args: {
        beforeIndex: number;
    }) => void;
    onRowDuplicated?: (args: {
        rowIndex: number;
    }) => void;
    onRowReset?: (args: {
        rowIndex: number;
    }) => void;
    onRowDeleted?: (args: {
        rowIndex: number;
    }) => void;
    onColumnAdded?: (args: {
        beforeIndex: number;
        currentIndex?: number;
        groupType: string | undefined;
        columnsCount: number;
        insertDirection: InsertRowColumnsDirection;
    }) => void;
    onColumnDeleted?: (args: {
        columnIndex: number;
        groupType: string | undefined;
    }) => void;
    shouldRenderRowIndexColumn: boolean;
    shouldShowRowsInlineControls: boolean;
    shouldShowColumnsInlineControls: boolean;
    resizerStopBehavior: ResizerStopBehavior;
    lastColumnMinWidth?: number;
}
export declare enum BeeTableHeaderVisibility {
    AllLevels = 0,
    LastLevel = 1,
    SecondToLastLevel = 2,
    None = 3
}
export declare enum BeeTableOperation {
    ColumnInsertLeft = 0,
    ColumnInsertRight = 1,
    ColumnInsertN = 2,
    ColumnDelete = 3,
    RowInsertAbove = 4,
    RowInsertBelow = 5,
    RowInsertN = 6,
    RowDelete = 7,
    RowReset = 8,
    RowDuplicate = 9,
    SelectionCopy = 10,
    SelectionCut = 11,
    SelectionPaste = 12,
    SelectionReset = 13
}
export interface BeeTableOperationGroup {
    group: string;
    items: {
        name: string;
        type: BeeTableOperation;
    }[];
}
export declare type BeeTableOperationConfig = BeeTableOperationGroup[] | {
    [columnGroupType: string]: BeeTableOperationGroup[];
};
export declare type BeeTableContextMenuAllowedOperationsConditions = {
    selection: BeeTableSelection;
    column: ReactTable.ColumnInstance<any> | undefined;
    columns: ReactTable.ColumnInstance<any>[] | undefined;
};
export declare enum InsertRowColumnsDirection {
    AboveOrRight = 0,
    BelowOrLeft = 1
}
//# sourceMappingURL=BeeTable.d.ts.map