import { Validator } from "@kie-tools/form/dist/Validator";
import { FormDmnJsonSchemaBridge } from "./uniforms";
import { DAYS_AND_TIME_DURATION_FORMAT, YEARS_AND_MONTHS_DURATION_FORMAT } from "@kie-tools/dmn-runner/dist/dmnFormats";
import { X_DMN_ALLOWED_VALUES_KEYWORD, X_DMN_TYPE_CONSTRAINTS_KEYWORD, } from "@kie-tools/dmn-runner/dist/jitExecutorKeywords";
import { DmnRunnerAjv } from "@kie-tools/dmn-runner/dist/ajv";
import { SCHEMA_DRAFT4 } from "@kie-tools/dmn-runner/dist/jsonSchemaConstants";
export class FormDmnValidator extends Validator {
    constructor(i18n) {
        super(i18n);
        this.dmnRunnerAjv = new DmnRunnerAjv();
    }
    createValidator(jsonSchema) {
        const validator = this.dmnRunnerAjv.getAjv().compile(jsonSchema);
        return (model) => {
            var _a, _b;
            validator(JSON.parse(JSON.stringify(model)));
            if (!((_a = validator.errors) === null || _a === void 0 ? void 0 : _a.length)) {
                return null;
            }
            return {
                details: (_b = validator.errors) === null || _b === void 0 ? void 0 : _b.map((error) => {
                    if (error.keyword === "format") {
                        if (error.params.format === DAYS_AND_TIME_DURATION_FORMAT) {
                            return Object.assign(Object.assign({}, error), { message: this.i18n.validation.daysAndTimeError });
                        }
                        if (error.params.format === YEARS_AND_MONTHS_DURATION_FORMAT) {
                            return Object.assign(Object.assign({}, error), { message: this.i18n.validation.yearsAndMonthsError });
                        }
                    }
                    if (error.keyword === X_DMN_ALLOWED_VALUES_KEYWORD) {
                        return Object.assign(Object.assign({}, error), { message: this.i18n.validation.xDmnAllowedValues });
                    }
                    if (error.keyword === X_DMN_TYPE_CONSTRAINTS_KEYWORD) {
                        return Object.assign(Object.assign({}, error), { message: this.i18n.validation.xDmnTypeConstraint });
                    }
                    return error;
                }),
            };
        };
    }
    getBridge(formSchema) {
        const formDraft4 = Object.assign(Object.assign({}, formSchema), { $schema: SCHEMA_DRAFT4 });
        const validator = this.createValidator(formDraft4);
        return new FormDmnJsonSchemaBridge(formDraft4, validator, this.i18n);
    }
}
//# sourceMappingURL=FormDmnValidator.js.map