var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { parseXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { KIE_DMN_UNKNOWN_NAMESPACE } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { buildXmlHref } from "../../xml/xmlHrefs";
export function computeIndexedDrd(thisDmnsNamespace, definitions, drdIndex) {
    var _a, _b, _c, _d, _e;
    var dmnEdgesByDmnElementRef = new Map();
    var dmnShapesByHref = new Map();
    var hrefsOfDmnElementRefsOfShapesPointingToExternalDmnObjects = new Set();
    var diagramElements = (_d = (_c = (_b = (_a = definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === null || _b === void 0 ? void 0 : _b[drdIndex]) === null || _c === void 0 ? void 0 : _c["dmndi:DMNDiagramElement"]) !== null && _d !== void 0 ? _d : [];
    for (var i = 0; i < diagramElements.length; i++) {
        var e = diagramElements[i];
        if (e.__$$element === "dmndi:DMNEdge") {
            dmnEdgesByDmnElementRef.set(e["@_dmnElementRef"], __assign(__assign({}, e), { index: i }));
        }
        else if (e.__$$element === "dmndi:DMNShape") {
            var href = void 0;
            var dmnElementRefQName = parseXmlQName(e["@_dmnElementRef"]);
            if (dmnElementRefQName.prefix) {
                var namespace = (_e = definitions["@_xmlns:".concat(dmnElementRefQName.prefix)]) !== null && _e !== void 0 ? _e : KIE_DMN_UNKNOWN_NAMESPACE;
                href = buildXmlHref({ namespace: namespace, id: dmnElementRefQName.localPart });
                hrefsOfDmnElementRefsOfShapesPointingToExternalDmnObjects.add(href);
            }
            else {
                href = buildXmlHref({
                    namespace: definitions["@_namespace"] === thisDmnsNamespace ? "" : definitions["@_namespace"],
                    id: dmnElementRefQName.localPart,
                });
            }
            dmnShapesByHref.set(href, __assign(__assign({}, e), { index: i, dmnElementRefQName: dmnElementRefQName }));
        }
        else {
        }
    }
    return {
        dmnEdgesByDmnElementRef: dmnEdgesByDmnElementRef,
        dmnShapesByHref: dmnShapesByHref,
        hrefsOfDmnElementRefsOfShapesPointingToExternalDmnObjects: hrefsOfDmnElementRefsOfShapesPointingToExternalDmnObjects,
    };
}
//# sourceMappingURL=computeIndexes.js.map