var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { useDmnEditorStoreApi } from "../store/StoreContext";
import { updateTextAnnotation } from "../mutations/renameNode";
export function TextAnnotationProperties(_a) {
    var _b, _c;
    var textAnnotation = _a.textAnnotation, index = _a.index;
    var setState = useDmnEditorStoreApi().setState;
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "Format" }, { children: _jsx(TextInput, { "aria-label": "Format", type: "text", isDisabled: false, value: textAnnotation["@_textFormat"], placeholder: "Enter a text format...", onChange: function (newTextFormat) {
                        setState(function (state) {
                            state.dmn.model.definitions.artifact[index]["@_textFormat"] =
                                newTextFormat;
                        });
                    } }) })), _jsx(FormGroup, __assign({ label: "Text" }, { children: _jsx(TextArea, { "aria-label": "Text", type: "text", isDisabled: false, value: (_b = textAnnotation.text) === null || _b === void 0 ? void 0 : _b.__$$text, onChange: function (newText) {
                        setState(function (state) {
                            updateTextAnnotation({
                                definitions: state.dmn.model.definitions,
                                index: index,
                                newText: newText,
                            });
                        });
                    }, placeholder: "Enter text...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) })), _jsx(FormGroup, __assign({ label: "Description" }, { children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: false, value: (_c = textAnnotation.description) === null || _c === void 0 ? void 0 : _c.__$$text, onChange: function (newDescription) {
                        setState(function (state) {
                            state.dmn.model.definitions.artifact[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 2 }) })), _jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: textAnnotation["@_id"] })) }))] }));
}
//# sourceMappingURL=TextAnnotationProperties.js.map