var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { Form, FormSection, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { DataSourceIcon } from "@patternfly/react-icons/dist/js/icons/data-source-icon";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { useState } from "react";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { SyncAltIcon } from "@patternfly/react-icons/dist/js/icons/sync-alt-icon";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { PropertiesPanelHeader } from "./PropertiesPanelHeader";
export function GlobalDiagramProperties() {
    var _a;
    var thisDmn = useDmnEditorStore(function (s) { return s.dmn; });
    var _b = __read(useState(true), 2), isGlobalSectionExpanded = _b[0], setGlobalSectionExpanded = _b[1];
    var _c = __read(useState(true), 2), isIdNamespaceSectionExpanded = _c[0], setIdNamespaceSectionExpanded = _c[1];
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _d = __read(useState(false), 2), regenerateIdConfirmationModal = _d[0], setRegenerateIdConfirmationModal = _d[1];
    return (_jsxs(Form, { children: [_jsx(FormSection, __assign({ title: _jsx(PropertiesPanelHeader, { expands: true, fixed: true, isSectionExpanded: isGlobalSectionExpanded, toogleSectionExpanded: function () { return setGlobalSectionExpanded(function (prev) { return !prev; }); }, icon: _jsx(DataSourceIcon, { width: 16, height: 36, style: { marginLeft: "12px" } }), title: "Global properties", action: _jsx(Button, __assign({ title: "Close", variant: ButtonVariant.plain, onClick: function () {
                            dmnEditorStoreApi.setState(function (state) {
                                state.diagram.propertiesPanel.isOpen = false;
                            });
                        } }, { children: _jsx(TimesIcon, {}) })) }) }, { children: isGlobalSectionExpanded && (_jsx(_Fragment, { children: _jsxs(FormSection, __assign({ style: { paddingLeft: "20px" } }, { children: [_jsx(FormGroup, __assign({ label: "Name" }, { children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: thisDmn.model.definitions["@_id"], name: thisDmn.model.definitions["@_name"], isReadonly: false, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: function (newName) {
                                        dmnEditorStoreApi.setState(function (state) {
                                            state.dmn.model.definitions["@_name"] = newName;
                                        });
                                    }, allUniqueNames: function () { return new Map(); } }) })), _jsx(FormGroup, __assign({ label: "Description" }, { children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: false, style: { resize: "vertical", minHeight: "40px" }, rows: 6, placeholder: "Enter a description...", value: (_a = thisDmn.model.definitions.description) === null || _a === void 0 ? void 0 : _a.__$$text, onChange: function (newDescription) {
                                        return dmnEditorStoreApi.setState(function (state) {
                                            state.dmn.model.definitions.description = { __$$text: newDescription };
                                        });
                                    } }) })), _jsx(FormGroup, __assign({ label: "Expression language" }, { children: _jsx(TextInput, { "aria-label": "Expression language", type: "text", isDisabled: false, placeholder: "Enter an expression language...", value: thisDmn.model.definitions["@_expressionLanguage"], onChange: function (newExprLang) {
                                        return dmnEditorStoreApi.setState(function (state) {
                                            state.dmn.model.definitions["@_expressionLanguage"] = newExprLang;
                                        });
                                    } }) }))] })) })) })), _jsx(FormSection, __assign({ style: { paddingTop: "20px" }, title: _jsx(PropertiesPanelHeader, { expands: true, isSectionExpanded: isIdNamespaceSectionExpanded, toogleSectionExpanded: function () { return setIdNamespaceSectionExpanded(function (prev) { return !prev; }); }, title: "ID & Namespace", action: _jsx(Button, __assign({ title: "Re-generate ID & Namespace", variant: ButtonVariant.plain, onClick: function () { return setRegenerateIdConfirmationModal(true); }, style: { paddingBottom: 0, paddingTop: 0 } }, { children: _jsx(SyncAltIcon, {}) })) }) }, { children: isIdNamespaceSectionExpanded && (_jsx(_Fragment, { children: _jsxs(FormSection, __assign({ style: { paddingLeft: "20px", marginTop: 0 } }, { children: [_jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ placeholder: "Enter a diagram ID...", isReadOnly: false, hoverTip: "Copy", clickTip: "Copied", onChange: function (newId) {
                                        dmnEditorStoreApi.setState(function (state) {
                                            state.dmn.model.definitions["@_id"] = "".concat(newId);
                                        });
                                    } }, { children: thisDmn.model.definitions["@_id"] })) })), _jsx(FormGroup, __assign({ label: "Namespace" }, { children: _jsx(ClipboardCopy, __assign({ placeholder: "Enter a diagram Namespace...", isReadOnly: false, hoverTip: "Copy", clickTip: "Copied", onChange: function (newNamespace) {
                                        dmnEditorStoreApi.setState(function (state) {
                                            state.dmn.model.definitions["@_namespace"] = "".concat(newNamespace);
                                        });
                                    } }, { children: thisDmn.model.definitions["@_namespace"] })) }))] })) })) })), _jsxs(Modal, __assign({ "aria-labelledby": "Regenerate ID & Namespace", variant: ModalVariant.small, isOpen: regenerateIdConfirmationModal, onClose: function () { return setRegenerateIdConfirmationModal(false); }, actions: [
                    _jsx(Button, __assign({ variant: ButtonVariant.primary, onClick: function () {
                            setRegenerateIdConfirmationModal(false);
                            dmnEditorStoreApi.setState(function (state) {
                                state.dmn.model.definitions["@_id"] = generateUuid();
                                state.dmn.model.definitions["@_namespace"] = "https://kie.apache.org/dmn/".concat(generateUuid());
                            });
                        } }, { children: "Yes, re-generate ID and Namespace" }), "confirm"),
                    _jsx(Button, __assign({ variant: "link", onClick: function () { return setRegenerateIdConfirmationModal(false); } }, { children: "Cancel" }), "cancel"),
                ] }, { children: ["Re-generating the ID and Namespace of a DMN file will potentially break other DMN files that depend on it.", _jsx("br", {}), _jsx("br", {}), "Are you sure you want to continue?"] }))] }));
}
//# sourceMappingURL=GlobalDiagramProperties.js.map