var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { DocumentationLinksFormGroup } from "./DocumentationLinksFormGroup";
import { TypeRefSelector } from "../dataTypes/TypeRefSelector";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { useCallback, useMemo } from "react";
import { buildXmlHref, parseXmlHref } from "../xml/xmlHrefs";
import { DmnObjectListItem } from "../externalNodes/DmnObjectListItem";
import { renameDrgElement } from "../mutations/renameNode";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { useDmnEditor } from "../DmnEditorContext";
import { useResolvedTypeRef } from "../dataTypes/useResolvedTypeRef";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { DragAndDrop, Draggable } from "../draggable/Draggable";
import { buildFeelQNameFromNamespace } from "../feel/buildFeelQName";
import { Alert, AlertVariant } from "@patternfly/react-core/dist/js/components/Alert/Alert";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export function DecisionServiceProperties(_a) {
    var _b, _c, _d;
    var decisionService = _a.decisionService, namespace = _a.namespace, index = _a.index;
    var setState = useDmnEditorStoreApi().setState;
    var thisDmn = useDmnEditorStore(function (s) { return s.dmn; });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var externalDmnsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).getExternalModelTypesByNamespace(externalModelsByNamespace).dmns; });
    var allDrgElementsByHref = useMemo(function () {
        var _a;
        var ret = new Map();
        var allDmns = __spreadArray([{ model: thisDmn.model }], __read(externalDmnsByNamespace.values()), false);
        for (var i = 0; i < allDmns.length; i++) {
            var anyDmn = allDmns[i];
            var namespace_1 = anyDmn.model.definitions["@_namespace"];
            var drgElements = (_a = anyDmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : [];
            for (var i_1 = 0; i_1 < drgElements.length; i_1++) {
                var element = drgElements[i_1];
                if (element.__$$element === "decision" || element.__$$element === "inputData") {
                    ret.set(buildXmlHref({ namespace: namespace_1, id: element["@_id"] }), element);
                }
            }
        }
        return ret;
    }, [externalDmnsByNamespace, thisDmn]);
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var isReadonly = !!namespace && namespace !== thisDmnsNamespace;
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var resolvedTypeRef = useResolvedTypeRef((_b = decisionService.variable) === null || _b === void 0 ? void 0 : _b["@_typeRef"], namespace);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "Name" }, { children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: decisionService["@_id"], name: decisionService["@_name"], isReadonly: isReadonly, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: function (newName) {
                        setState(function (state) {
                            renameDrgElement({
                                definitions: state.dmn.model.definitions,
                                index: index,
                                newName: newName,
                            });
                        });
                    }, allUniqueNames: useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []) }) })), _jsx(FormGroup, __assign({ label: "Data type" }, { children: _jsx(TypeRefSelector, { heightRef: dmnEditorRootElementRef, typeRef: resolvedTypeRef, isDisabled: isReadonly, onChange: function (newTypeRef) {
                        setState(function (state) {
                            var _a;
                            var drgElement = state.dmn.model.definitions.drgElement[index];
                            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": decisionService["@_name"] });
                            drgElement.variable["@_typeRef"] = newTypeRef;
                        });
                    } }) })), _jsx(FormGroup, __assign({ label: "Description" }, { children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: isReadonly, value: (_c = decisionService.description) === null || _c === void 0 ? void 0 : _c.__$$text, onChange: function (newDescription) {
                        setState(function (state) {
                            state.dmn.model.definitions.drgElement[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) })), _jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: decisionService["@_id"] })) })), _jsx(FormGroup, __assign({ label: "Output decisions" }, { children: _jsx(DecisionServiceElementList, { decisionServiceNamespace: namespace, elements: decisionService.outputDecision, allDrgElementsByHref: allDrgElementsByHref }) })), _jsx(FormGroup, __assign({ label: "Encapsulated decisions" }, { children: _jsx(DecisionServiceElementList, { decisionServiceNamespace: namespace, elements: decisionService.encapsulatedDecision, allDrgElementsByHref: allDrgElementsByHref }) })), _jsx(Divider, {}), _jsx(FormGroup, __assign({ label: "Input decisions" }, { children: _jsx(DraggableDecisionServiceElementList, { decisionServiceNamespace: namespace, elements: decisionService.inputDecision, allDrgElementsByHref: allDrgElementsByHref, onChange: function (newInputDecisions) {
                        setState(function (state) {
                            state.dmn.model.definitions.drgElement[index].inputDecision =
                                newInputDecisions;
                        });
                    }, isDisabled: isReadonly }) })), _jsx(FormGroup, __assign({ label: "Input data" }, { children: _jsx(DraggableDecisionServiceElementList, { decisionServiceNamespace: namespace, elements: decisionService.inputData, allDrgElementsByHref: allDrgElementsByHref, onChange: function (newInputData) {
                        setState(function (state) {
                            state.dmn.model.definitions.drgElement[index].inputData =
                                newInputData;
                        });
                    }, isDisabled: isReadonly }) })), _jsx(DecisionServiceEquivalentFunction, { decisionService: decisionService, decisionServiceNamespace: namespace, allDrgElementsByHref: allDrgElementsByHref }), _jsx(DocumentationLinksFormGroup, { isReadonly: isReadonly, values: (_d = decisionService.extensionElements) === null || _d === void 0 ? void 0 : _d["kie:attachment"], onChange: function (newExtensionElements) {
                    setState(function (state) {
                        state.dmn.model.definitions.drgElement[index].extensionElements =
                            {
                                "kie:attachment": newExtensionElements,
                            };
                    });
                } })] }));
}
export function DecisionServiceElementList(_a) {
    var decisionServiceNamespace = _a.decisionServiceNamespace, elements = _a.elements, allDrgElementsByHref = _a.allDrgElementsByHref;
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    return (_jsxs("ul", { children: [(elements !== null && elements !== void 0 ? elements : []).length <= 0 && (_jsx("li", __assign({ style: { paddingLeft: "32px" } }, { children: _jsx("small", { children: _jsx("i", { children: "(Empty)" }) }) }))), (elements !== null && elements !== void 0 ? elements : []).map(function (e) {
                var _a, _b;
                var localHref = parseXmlHref(e["@_href"]);
                var resolvedNamespace = (_b = (_a = localHref.namespace) !== null && _a !== void 0 ? _a : decisionServiceNamespace) !== null && _b !== void 0 ? _b : thisDmnsNamespace;
                var potentialExternalHref = buildXmlHref({
                    namespace: resolvedNamespace,
                    id: localHref.id,
                });
                return (_jsx("li", __assign({ style: { paddingLeft: "32px" } }, { children: _jsx(DmnObjectListItem, { dmnObjectHref: potentialExternalHref, dmnObject: allDrgElementsByHref.get(potentialExternalHref), relativeToNamespace: thisDmnsNamespace, namespace: resolvedNamespace }) }), potentialExternalHref));
            })] }));
}
export function DraggableDecisionServiceElementList(_a) {
    var decisionServiceNamespace = _a.decisionServiceNamespace, elements = _a.elements, allDrgElementsByHref = _a.allDrgElementsByHref, onChange = _a.onChange, isDisabled = _a.isDisabled;
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var _b = __read(React.useState(function () { var _a; return (_a = elements === null || elements === void 0 ? void 0 : elements.map(function (e) { return e["@_href"]; })) !== null && _a !== void 0 ? _a : []; }), 2), keys = _b[0], setKeys = _b[1];
    var onDragEnd = useCallback(function (source, dest) {
        var reordened = __spreadArray([], __read((elements !== null && elements !== void 0 ? elements : [])), false);
        var _a = __read(reordened.splice(source, 1), 1), removed = _a[0];
        reordened.splice(dest, 0, removed);
        onChange(reordened);
    }, [elements, onChange]);
    var reorder = useCallback(function (source, dest) {
        setKeys(function (prev) {
            var reordenedUuid = __spreadArray([], __read(prev), false);
            var _a = __read(reordenedUuid.splice(source, 1), 1), removedUuid = _a[0];
            reordenedUuid.splice(dest, 0, removedUuid);
            return reordenedUuid;
        });
    }, []);
    var draggableItem = useCallback(function (element, index) {
        var _a, _b;
        var localHref = parseXmlHref(element["@_href"]);
        var resolvedNamespace = (_b = (_a = localHref.namespace) !== null && _a !== void 0 ? _a : decisionServiceNamespace) !== null && _b !== void 0 ? _b : thisDmnsNamespace;
        var potentialExternalHref = buildXmlHref({
            namespace: resolvedNamespace,
            id: localHref.id,
        });
        return (_jsx(Draggable, __assign({ index: index, handlerStyle: keys[index] ? { paddingLeft: "16px", paddingRight: "16px" } : { paddingLeft: "16px", paddingRight: "16px" }, isDisabled: isDisabled }, { children: _jsx("li", { children: _jsx(DmnObjectListItem, { dmnObjectHref: potentialExternalHref, dmnObject: allDrgElementsByHref.get(potentialExternalHref), relativeToNamespace: thisDmnsNamespace, namespace: resolvedNamespace }) }, potentialExternalHref) }), keys[index]));
    }, [allDrgElementsByHref, decisionServiceNamespace, isDisabled, keys, thisDmnsNamespace]);
    return (_jsxs("ul", { children: [(elements !== null && elements !== void 0 ? elements : []).length <= 0 && (_jsx("li", __assign({ style: { paddingLeft: "32px" } }, { children: _jsx("small", { children: _jsx("i", { children: "(Empty)" }) }) }))), _jsx(DragAndDrop, { reorder: reorder, onDragEnd: onDragEnd, values: elements, draggableItem: draggableItem, isDisabled: isDisabled })] }));
}
function DecisionServiceEquivalentFunction(_a) {
    var decisionService = _a.decisionService, allDrgElementsByHref = _a.allDrgElementsByHref, decisionServiceNamespace = _a.decisionServiceNamespace;
    var importsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).importsByNamespace(); });
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var getNodeNameByHref = useCallback(function (href) {
        var _a, _b;
        var localHref = parseXmlHref(href);
        var resolvedNamespace = (_b = (_a = localHref.namespace) !== null && _a !== void 0 ? _a : decisionServiceNamespace) !== null && _b !== void 0 ? _b : thisDmnsNamespace;
        var potentialExternalHref = buildXmlHref({
            namespace: resolvedNamespace,
            id: localHref.id,
        });
        var dmnObject = allDrgElementsByHref.get(potentialExternalHref);
        return dmnObject
            ? buildFeelQNameFromNamespace({
                namedElement: dmnObject,
                importsByNamespace: importsByNamespace,
                namespace: resolvedNamespace,
                relativeToNamespace: thisDmnsNamespace,
            }).full
            : potentialExternalHref;
    }, [allDrgElementsByHref, decisionServiceNamespace, importsByNamespace, thisDmnsNamespace]);
    var buildFunctionArgList = useCallback(function (inputDecisions, inputData) {
        var inputDecisionNodeNames = inputDecisions === null || inputDecisions === void 0 ? void 0 : inputDecisions.map(function (ide) { return getNodeNameByHref(ide["@_href"]); });
        var inputDataNodeNames = inputData === null || inputData === void 0 ? void 0 : inputData.map(function (ida) { return getNodeNameByHref(ida["@_href"]); });
        return __spreadArray(__spreadArray([], __read((inputDecisionNodeNames !== null && inputDecisionNodeNames !== void 0 ? inputDecisionNodeNames : [])), false), __read((inputDataNodeNames !== null && inputDataNodeNames !== void 0 ? inputDataNodeNames : [])), false).reduce(function (acc, name) { return (acc ? "".concat(acc, ", ").concat(name) : name); }, "");
    }, [getNodeNameByHref]);
    return (_jsx(Alert, __assign({ variant: AlertVariant.info, isInline: true, title: "Invoking this Decision Service in FEEL" }, { children: _jsx("p", __assign({ style: { fontFamily: "monospace" } }, { children: "".concat(decisionService["@_name"], "(").concat(buildFunctionArgList(decisionService.inputDecision, decisionService.inputData), ")") })) })));
}
//# sourceMappingURL=DecisionServiceProperties.js.map