import { useCallback, useMemo } from "react";
import { getDmnObjectByPath } from "../../boxedExpressions/boxedExpressionIndex";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { buildXmlHref } from "../../xml/xmlHrefs";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
export function useBoxedExpressionUpdater(expressionPath) {
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var activeDrgElementId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.activeDrgElementId; });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var node = useMemo(function () {
        var nodesById = dmnEditorStoreApi
            .getState()
            .computed(dmnEditorStoreApi.getState())
            .getDiagramData(externalModelsByNamespace).nodesById;
        return activeDrgElementId ? nodesById.get(buildXmlHref({ id: activeDrgElementId })) : undefined;
    }, [activeDrgElementId, dmnEditorStoreApi, externalModelsByNamespace]);
    return useCallback(function (consumer) {
        dmnEditorStoreApi.setState(function (state) {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
            if (((_c = (_a = state.dmn.model.definitions.drgElement) === null || _a === void 0 ? void 0 : _a[(_b = node === null || node === void 0 ? void 0 : node.data.index) !== null && _b !== void 0 ? _b : 0]) === null || _c === void 0 ? void 0 : _c.__$$element) === "businessKnowledgeModel") {
                var dmnObject = getDmnObjectByPath(expressionPath !== null && expressionPath !== void 0 ? expressionPath : [], (_f = (_d = state.dmn.model.definitions.drgElement) === null || _d === void 0 ? void 0 : _d[(_e = node === null || node === void 0 ? void 0 : node.data.index) !== null && _e !== void 0 ? _e : 0]) === null || _f === void 0 ? void 0 : _f.encapsulatedLogic);
                dmnObject && consumer(dmnObject);
            }
            if (((_j = (_g = state.dmn.model.definitions.drgElement) === null || _g === void 0 ? void 0 : _g[(_h = node === null || node === void 0 ? void 0 : node.data.index) !== null && _h !== void 0 ? _h : 0]) === null || _j === void 0 ? void 0 : _j.__$$element) === "decision") {
                var dmnObject = getDmnObjectByPath(expressionPath !== null && expressionPath !== void 0 ? expressionPath : [], (_m = (_k = state.dmn.model.definitions.drgElement) === null || _k === void 0 ? void 0 : _k[(_l = node === null || node === void 0 ? void 0 : node.data.index) !== null && _l !== void 0 ? _l : 0]) === null || _m === void 0 ? void 0 : _m.expression);
                dmnObject && consumer(dmnObject);
            }
        });
    }, [dmnEditorStoreApi, expressionPath, node === null || node === void 0 ? void 0 : node.data.index]);
}
//# sourceMappingURL=useBoxedExpressionUpdater.js.map