var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { snapShapeDimensions, snapShapePosition } from "../diagram/SnapGrid";
import { PositionalNodeHandleId } from "../diagram/connections/PositionalNodeHandles";
import { getHandlePosition } from "../diagram/maths/DmnMaths";
import { MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { addOrGetDrd } from "./addOrGetDrd";
import { DECISION_SERVICE_DIVIDER_LINE_PADDING } from "./updateDecisionServiceDividerLine";
export function resizeNode(_a) {
    var _b, _c, _d, _e, _f, _g;
    var definitions = _a.definitions, drdIndex = _a.drdIndex, __readonly_dmnShapesByHref = _a.__readonly_dmnShapesByHref, __readonly_dmnObjectNamespace = _a.__readonly_dmnObjectNamespace, __readonly_externalDmnsIndex = _a.__readonly_externalDmnsIndex, snapGrid = _a.snapGrid, change = _a.change;
    var edgeIndexesAlreadyUpdated = new Set();
    var diagramElements = addOrGetDrd({ definitions: definitions, drdIndex: drdIndex }).diagramElements;
    var shape = diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements[change.shapeIndex];
    var shapeBounds = shape === null || shape === void 0 ? void 0 : shape["dc:Bounds"];
    if (!shapeBounds) {
        throw new Error("DMN MUTATION: Cannot resize non-existent shape bounds");
    }
    var limit = { x: 0, y: 0 };
    if (change.nodeType === NODE_TYPES.decisionService) {
        var externalDmn = __readonly_externalDmnsIndex.get(__readonly_dmnObjectNamespace !== null && __readonly_dmnObjectNamespace !== void 0 ? __readonly_dmnObjectNamespace : "");
        var ds = externalDmn === undefined
            ? definitions.drgElement[change.index]
            : externalDmn.model.definitions.drgElement[change.index];
        if (!ds) {
            throw new Error("DMN MUTATION: Cannot reposition divider line of non-existent Decision Service");
        }
        var dividerLineY = (_e = (_d = (_c = (_b = shape["dmndi:DMNDecisionServiceDividerLine"]) === null || _b === void 0 ? void 0 : _b["di:waypoint"]) === null || _c === void 0 ? void 0 : _c[0]) === null || _d === void 0 ? void 0 : _d["@_y"]) !== null && _e !== void 0 ? _e : shapeBounds["@_y"];
        limit.y = dividerLineY + DECISION_SERVICE_DIVIDER_LINE_PADDING;
        if (!change.isExternal) {
            (_f = ds.encapsulatedDecision) === null || _f === void 0 ? void 0 : _f.forEach(function (ed) {
                var edShape = __readonly_dmnShapesByHref.get(ed["@_href"]);
                var dim = snapShapeDimensions(snapGrid, edShape, MIN_NODE_SIZES[NODE_TYPES.decision]({ snapGrid: snapGrid }));
                var pos = snapShapePosition(snapGrid, edShape);
                if (pos.x + dim.width > limit.x) {
                    limit.x = pos.x + dim.width;
                }
                if (pos.y + dim.height > limit.y) {
                    limit.y = pos.y + dim.height;
                }
            });
            (_g = ds.outputDecision) === null || _g === void 0 ? void 0 : _g.forEach(function (ed) {
                var edShape = __readonly_dmnShapesByHref.get(ed["@_href"]);
                var dim = snapShapeDimensions(snapGrid, edShape, MIN_NODE_SIZES[NODE_TYPES.decision]({ snapGrid: snapGrid }));
                var pos = snapShapePosition(snapGrid, edShape);
                if (pos.x + dim.width > limit.x) {
                    limit.x = pos.x + dim.width;
                }
            });
        }
    }
    var snappedPosition = snapShapePosition(snapGrid, shape);
    var newDimensions = {
        width: Math.max(change.dimension["@_width"], limit.x - snappedPosition.x),
        height: Math.max(change.dimension["@_height"], limit.y - snappedPosition.y),
    };
    var deltaWidth = newDimensions.width - shapeBounds["@_width"];
    var deltaHeight = newDimensions.height - shapeBounds["@_height"];
    var offsetByPosition = function (position) {
        var _a;
        return switchExpression(position, (_a = {},
            _a[PositionalNodeHandleId.Center] = { x: deltaWidth / 2, y: deltaHeight / 2 },
            _a[PositionalNodeHandleId.Top] = { x: deltaWidth / 2, y: 0 },
            _a[PositionalNodeHandleId.Right] = { x: deltaWidth, y: deltaHeight / 2 },
            _a[PositionalNodeHandleId.Bottom] = { x: deltaWidth / 2, y: deltaHeight },
            _a[PositionalNodeHandleId.Left] = { x: 0, y: deltaHeight / 2 },
            _a));
    };
    var offsetEdges = function (args) {
        var e_1, _a;
        try {
            for (var _b = __values(args.edgeIndexes), _c = _b.next(); !_c.done; _c = _b.next()) {
                var edgeIndex = _c.value;
                if (edgeIndexesAlreadyUpdated.has(edgeIndex)) {
                    continue;
                }
                edgeIndexesAlreadyUpdated.add(edgeIndex);
                var edge = diagramElements[edgeIndex];
                if (!edge || !edge["di:waypoint"]) {
                    throw new Error("DMN MUTATION: Cannot reposition non-existent edge");
                }
                var waypoint = switchExpression(args.waypointSelector, {
                    first: edge["di:waypoint"][0],
                    last: edge["di:waypoint"][edge["di:waypoint"].length - 1],
                });
                var offset = offsetByPosition(getHandlePosition({ shapeBounds: shapeBounds, waypoint: waypoint }).handlePosition);
                waypoint["@_x"] += offset.x;
                waypoint["@_y"] += offset.y;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    offsetEdges({ edgeIndexes: change.sourceEdgeIndexes, waypointSelector: "first" });
    offsetEdges({ edgeIndexes: change.targetEdgeIndexes, waypointSelector: "last" });
    shapeBounds["@_width"] = newDimensions.width;
    shapeBounds["@_height"] = newDimensions.height;
}
//# sourceMappingURL=resizeNode.js.map