var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { ns as dmn12ns } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_2/ts-gen/meta";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Card, CardActions, CardBody, CardHeader, CardTitle } from "@patternfly/react-core/dist/js/components/Card";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Select, SelectGroup, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Gallery } from "@patternfly/react-core/dist/js/layouts/Gallery";
import { CubesIcon } from "@patternfly/react-icons/dist/js/icons/cubes-icon";
import { basename, dirname, extname } from "path";
import { useCallback, useMemo, useRef, useState } from "react";
import { useDmnEditor } from "../DmnEditorContext";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { addImport } from "../mutations/addImport";
import { deleteImport } from "../mutations/deleteImport";
import { renameImport } from "../mutations/renameImport";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { KIE_UNKNOWN_NAMESPACE } from "../kie/kie";
import { ExternalModelLabel } from "./ExternalModelLabel";
import { useExternalModels } from "./DmnEditorDependenciesContext";
import { allPmmlImportNamespaces, getPmmlNamespace } from "../pmml/pmml";
import { allDmnImportNamespaces } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { getNamespaceOfDmnImport } from "./importNamespaces";
import { Alert, AlertVariant } from "@patternfly/react-core/dist/js/components/Alert/Alert";
import { KebabToggle } from "@patternfly/react-core/dist/js/components/Dropdown";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
import { useInViewSelect } from "../responsiveness/useInViewSelect";
import { useCancelableEffect } from "@kie-tools-core/react-hooks/dist/useCancelableEffect";
import "./IncludedModels.css";
import { Popover, PopoverPosition } from "@patternfly/react-core/dist/js/components/Popover";
import { AlertActionCloseButton, AlertActionLink } from "@patternfly/react-core/dist/js/components/Alert";
export var EMPTY_IMPORT_NAME_NAMESPACE_IDENTIFIER = "<Default>";
var namespaceForNewImportsByFileExtension = {
    ".dmn": dmn12ns.get(""),
    ".pmml": "https://www.dmg.org/PMML-4_4",
};
export function IncludedModels() {
    var _a, _b, _c, _d;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var thisDmnsImports = useDmnEditorStore(function (s) { var _a; return (_a = s.dmn.model.definitions.import) !== null && _a !== void 0 ? _a : []; });
    var _e = useDmnEditor(), externalContextDescription = _e.externalContextDescription, externalContextName = _e.externalContextName, dmnEditorRootElementRef = _e.dmnEditorRootElementRef, onRequestToResolvePath = _e.onRequestToResolvePath;
    var importsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).importsByNamespace(); });
    var _f = useExternalModels(), externalModelsByNamespace = _f.externalModelsByNamespace, onRequestExternalModelsAvailableToInclude = _f.onRequestExternalModelsAvailableToInclude, onRequestExternalModelByPath = _f.onRequestExternalModelByPath;
    var _g = __read(useState(false), 2), isModalOpen = _g[0], setModalOpen = _g[1];
    var _h = __read(useState(false), 2), isModelSelectOpen = _h[0], setModelSelectOpen = _h[1];
    var _j = __read(useState(undefined), 2), selectedPathRelativeToThisDmn = _j[0], setSelectedPathRelativeToThisDmn = _j[1];
    var _k = __read(useState(""), 2), importName = _k[0], setImportName = _k[1];
    var _l = __read(useState(undefined), 2), selectedModel = _l[0], setSelectedModel = _l[1];
    var _m = __read(useState(undefined), 2), selectedModelError = _m[0], setSelectedModelError = _m[1];
    useCancelableEffect(useCallback(function (_a) {
        var canceled = _a.canceled;
        if (!selectedPathRelativeToThisDmn) {
            return;
        }
        if (onRequestExternalModelByPath === undefined) {
            return;
        }
        onRequestExternalModelByPath(selectedPathRelativeToThisDmn)
            .then(function (externalModel) {
            if (canceled.get()) {
                return;
            }
            if (!externalModel) {
                return;
            }
            setSelectedModelError(undefined);
            setSelectedModel(externalModel);
        })
            .catch(function (err) {
            setSelectedModelError("An error occurred when parsing the selected model '".concat(selectedPathRelativeToThisDmn, "'. Please double-check it is a non-empty valid model."));
            console.error(err);
            return;
        });
    }, [onRequestExternalModelByPath, selectedPathRelativeToThisDmn]));
    var openModal = useCallback(function () {
        setModalOpen(true);
    }, []);
    var cancel = useCallback(function () {
        setModalOpen(false);
        setModelSelectOpen(false);
        setSelectedPathRelativeToThisDmn(undefined);
        setImportName("");
        setSelectedModelError(undefined);
    }, []);
    var add = useCallback(function () {
        var s = dmnEditorStoreApi.getState();
        if (!selectedPathRelativeToThisDmn ||
            !selectedModel ||
            !DMN15_SPEC.IMPORT.name.isValid(generateUuid(), importName, s.computed(s).getAllFeelVariableUniqueNames())) {
            return;
        }
        var xmlns = namespaceForNewImportsByFileExtension[extname(selectedPathRelativeToThisDmn)];
        if (!xmlns) {
            throw new Error("Can't import model with an unsupported file extension: '".concat(selectedPathRelativeToThisDmn, "'."));
        }
        var namespace = selectedModel.type === "dmn"
            ? selectedModel.model.definitions["@_namespace"]
            : selectedModel.type === "pmml"
                ? getPmmlNamespace({
                    normalizedPosixPathRelativeToTheOpenFile: selectedModel.normalizedPosixPathRelativeToTheOpenFile,
                })
                : KIE_UNKNOWN_NAMESPACE;
        setModalOpen(false);
        dmnEditorStoreApi.setState(function (state) {
            addImport({
                definitions: state.dmn.model.definitions,
                includedModel: {
                    xmlns: xmlns,
                    namespace: namespace,
                    name: importName,
                    normalizedPathRelativeToThisDmn: selectedModel.normalizedPosixPathRelativeToTheOpenFile,
                },
            });
        });
        setTimeout(function () {
            setSelectedModelError(undefined);
            setSelectedModel(undefined);
        }, 5000);
        cancel();
    }, [dmnEditorStoreApi, selectedPathRelativeToThisDmn, selectedModel, importName, cancel]);
    var _o = __read(useState(undefined), 2), modelPathRelativeToThisDmn = _o[0], setModelPathsRelativeToThisDmn = _o[1];
    useCancelableEffect(useCallback(function (_a) {
        var canceled = _a.canceled;
        onRequestExternalModelsAvailableToInclude === null || onRequestExternalModelsAvailableToInclude === void 0 ? void 0 : onRequestExternalModelsAvailableToInclude().then(function (paths) {
            if (canceled.get()) {
                return;
            }
            setModelPathsRelativeToThisDmn(paths);
        }).catch(function (err) {
            console.error(err);
            return;
        });
    }, [onRequestExternalModelsAvailableToInclude]));
    var externalModelsByPathsRelativeToThisDmn = useMemo(function () {
        return Object.entries(externalModelsByNamespace !== null && externalModelsByNamespace !== void 0 ? externalModelsByNamespace : {}).reduce(function (acc, _a) {
            var _b = __read(_a, 2), namespace = _b[0], externalModel = _b[1];
            if (!externalModel) {
                console.warn("DMN EDITOR: Could not find model with namespace '".concat(namespace, "'. Ignoring."));
                return acc;
            }
            else {
                return acc.set(externalModel.normalizedPosixPathRelativeToTheOpenFile, externalModel);
            }
        }, new Map());
    }, [externalModelsByNamespace]);
    var modelPathsRelativeToThisDmnNotYetIncluded = useMemo(function () {
        return modelPathRelativeToThisDmn &&
            modelPathRelativeToThisDmn.filter(function (path) {
                var externalModel = externalModelsByPathsRelativeToThisDmn.get(path);
                return (!externalModel ||
                    (externalModel.type === "dmn" && !importsByNamespace.get(externalModel.model.definitions["@_namespace"])) ||
                    (externalModel.type === "pmml" &&
                        !importsByNamespace.get(getPmmlNamespace({
                            normalizedPosixPathRelativeToTheOpenFile: externalModel.normalizedPosixPathRelativeToTheOpenFile,
                        }))));
            });
    }, [externalModelsByPathsRelativeToThisDmn, importsByNamespace, modelPathRelativeToThisDmn]);
    var pmmlPathsNotYetIncluded = useMemo(function () { return modelPathsRelativeToThisDmnNotYetIncluded === null || modelPathsRelativeToThisDmnNotYetIncluded === void 0 ? void 0 : modelPathsRelativeToThisDmnNotYetIncluded.filter(function (s) { return s.endsWith(".pmml"); }); }, [modelPathsRelativeToThisDmnNotYetIncluded]);
    var dmnPathsNotYetIncluded = useMemo(function () { return modelPathsRelativeToThisDmnNotYetIncluded === null || modelPathsRelativeToThisDmnNotYetIncluded === void 0 ? void 0 : modelPathsRelativeToThisDmnNotYetIncluded.filter(function (s) { return s.endsWith(".dmn"); }); }, [modelPathsRelativeToThisDmnNotYetIncluded]);
    var selectToggleRef = useRef(null);
    var inViewSelect = useInViewSelect(dmnEditorRootElementRef, selectToggleRef);
    var getAllUniqueNames = useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []);
    return (_jsxs(_Fragment, { children: [_jsx(Modal, __assign({ isOpen: isModalOpen, onClose: function () { return cancel(); }, title: "Include model", variant: ModalVariant.large, actions: ((_a = modelPathsRelativeToThisDmnNotYetIncluded === null || modelPathsRelativeToThisDmnNotYetIncluded === void 0 ? void 0 : modelPathsRelativeToThisDmnNotYetIncluded.length) !== null && _a !== void 0 ? _a : 0) > 0 && selectedModelError === undefined
                    ? [
                        _jsx(Button, __assign({ variant: "primary", onClick: add }, { children: "Include model" }), "confirm"),
                        _jsx(Button, __assign({ variant: "link", onClick: cancel }, { children: "Cancel" }), "cancel"),
                    ]
                    : [
                        _jsx(Button, __assign({ variant: "link", onClick: cancel, style: { paddingLeft: 0 } }, { children: "Cancel" }), "cancel"),
                    ] }, { children: (modelPathsRelativeToThisDmnNotYetIncluded && (_jsx(_Fragment, { children: (modelPathsRelativeToThisDmnNotYetIncluded.length > 0 && (_jsxs(_Fragment, { children: [_jsx("br", {}), externalContextDescription, _jsx("br", {}), _jsx("br", {}), _jsxs(Form, { children: [_jsx(FormGroup, __assign({ label: "Model", isRequired: true }, { children: _jsxs(Select, __assign({ toggleRef: selectToggleRef, maxHeight: inViewSelect.maxHeight, direction: inViewSelect.direction, menuAppendTo: document.body, variant: SelectVariant.typeahead, typeAheadAriaLabel: "Select a model to include...", placeholderText: "Select a model to include...", onToggle: setModelSelectOpen, onClear: function () { return setSelectedPathRelativeToThisDmn(undefined); }, onSelect: function (e, path) {
                                                if (typeof path !== "string") {
                                                    throw new Error("Invalid path for an included model ".concat(JSON.stringify(path)));
                                                }
                                                setSelectedPathRelativeToThisDmn(path);
                                                setModelSelectOpen(false);
                                            }, selections: selectedPathRelativeToThisDmn, isOpen: isModelSelectOpen, "aria-labelledby": "Included model selector", isGrouped: true }, { children: [_jsx(SelectGroup, __assign({ label: "DMN" }, { children: (((_b = dmnPathsNotYetIncluded === null || dmnPathsNotYetIncluded === void 0 ? void 0 : dmnPathsNotYetIncluded.length) !== null && _b !== void 0 ? _b : 0) > 0 &&
                                                        (dmnPathsNotYetIncluded === null || dmnPathsNotYetIncluded === void 0 ? void 0 : dmnPathsNotYetIncluded.map(function (p) {
                                                            var _a;
                                                            var normalizedPosixPathRelativeToTheWorkspaceRoot = (_a = onRequestToResolvePath === null || onRequestToResolvePath === void 0 ? void 0 : onRequestToResolvePath(p)) !== null && _a !== void 0 ? _a : p;
                                                            return (_jsx(SelectOption, __assign({ description: dirname(normalizedPosixPathRelativeToTheWorkspaceRoot), value: p }, { children: basename(normalizedPosixPathRelativeToTheWorkspaceRoot) }), normalizedPosixPathRelativeToTheWorkspaceRoot));
                                                        }))) || (_jsx(SelectOption, __assign({ isDisabled: true, description: "", value: "" }, { children: _jsx("i", { children: "None" }) }), "none-dmn")) }), "DMN"), _jsx(Divider, {}, "divider"), _jsx(SelectGroup, __assign({ label: "PMML" }, { children: (((_c = pmmlPathsNotYetIncluded === null || pmmlPathsNotYetIncluded === void 0 ? void 0 : pmmlPathsNotYetIncluded.length) !== null && _c !== void 0 ? _c : 0) > 0 &&
                                                        (pmmlPathsNotYetIncluded === null || pmmlPathsNotYetIncluded === void 0 ? void 0 : pmmlPathsNotYetIncluded.map(function (p) {
                                                            var _a;
                                                            var normalizedPosixPathRelativeToTheWorkspaceRoot = (_a = onRequestToResolvePath === null || onRequestToResolvePath === void 0 ? void 0 : onRequestToResolvePath(p)) !== null && _a !== void 0 ? _a : p;
                                                            return (_jsx(SelectOption, __assign({ description: dirname(normalizedPosixPathRelativeToTheWorkspaceRoot), value: p }, { children: basename(normalizedPosixPathRelativeToTheWorkspaceRoot) }), normalizedPosixPathRelativeToTheWorkspaceRoot));
                                                        }))) || (_jsx(SelectOption, __assign({ isDisabled: true, description: "", value: "" }, { children: _jsx("i", { children: "None" }) }), "none-pmml")) }), "PMML")] })) })), _jsx(FormGroup, __assign({ label: "Name" }, { children: _jsx(InlineFeelNameInput, { validate: DMN15_SPEC.IMPORT.name.isValid, placeholder: EMPTY_IMPORT_NAME_NAMESPACE_IDENTIFIER, isPlain: false, id: generateUuid(), name: importName, isReadonly: false, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: setImportName, allUniqueNames: getAllUniqueNames }) })), _jsx("br", {}), selectedModelError !== undefined && (_jsx("span", __assign({ className: "kie-dmn-editor--selected-model-to-include-error" }, { children: selectedModelError })))] })] }))) || (_jsx(_Fragment, { children: (((_d = modelPathRelativeToThisDmn === null || modelPathRelativeToThisDmn === void 0 ? void 0 : modelPathRelativeToThisDmn.length) !== null && _d !== void 0 ? _d : 0) > 0 &&
                            "All models available".concat(externalContextName ? " in '".concat(externalContextName, "' ") : " ", "are already included.")) ||
                            "There's no available models".concat(externalContextName ? " in '".concat(externalContextName, "' ") : " ", "to be included.") })) }))) || _jsx(_Fragment, { children: "Loading..." }) })), thisDmnsImports.length > 0 && (_jsx(_Fragment, { children: _jsxs(PageSection, __assign({ style: { padding: "24px" } }, { children: [_jsx(Button, __assign({ onClick: openModal, variant: ButtonVariant.primary }, { children: "Include model" })), _jsx("br", {}), _jsx("br", {}), _jsx(Divider, { inset: { default: "insetMd" } }), _jsx("br", {}), _jsx(Gallery, __assign({ hasGutter: true, minWidths: { xl: "calc(25% - 1rem)", md: "calc(33% - 1rem)", sm: "100%" } }, { children: thisDmnsImports.flatMap(function (dmnImport, index) {
                                var _a;
                                var externalModel = (_a = externalModelsByNamespace === null || externalModelsByNamespace === void 0 ? void 0 : externalModelsByNamespace[getNamespaceOfDmnImport({ dmnImport: dmnImport })]) !== null && _a !== void 0 ? _a : (!isModalOpen && index === thisDmnsImports.length - 1 ? selectedModel : undefined);
                                return !externalModel ? (_jsx(IncludedModelCard, { _import: dmnImport, index: index, externalModel: undefined, isReadonly: false }, dmnImport["@_id"])) : (_jsx(IncludedModelCard, { _import: dmnImport, index: index, externalModel: externalModel, isReadonly: false }, dmnImport["@_id"]));
                            }) }))] })) })), thisDmnsImports.length <= 0 && (_jsx(Flex, __assign({ justifyContent: { default: "justifyContentCenter" }, style: { marginTop: "100px" } }, { children: _jsxs(EmptyState, __assign({ style: { maxWidth: "1280px" } }, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, __assign({ size: "lg", headingLevel: "h4" }, { children: "No external models have been included." })), _jsx(EmptyStateBody, { children: "Included models are externally defined models that have been added to this DMN file. Included DMN models have their decision requirements diagram (DRD) or decision requirements graph (DRG) components available in this DMN file. Included PMML models can be invoked through DMN Boxed Functions, usually inside Business Knowledge Model nodes (BKMs)" }), _jsx(Button, __assign({ onClick: openModal, variant: ButtonVariant.primary }, { children: "Include model" }))] })) })))] }));
}
function IncludedModelCard(_a) {
    var _b;
    var _import = _a._import, index = _a.index, externalModel = _a.externalModel, isReadonly = _a.isReadonly;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _c = useDmnEditor(), onRequestToJumpToPath = _c.onRequestToJumpToPath, onRequestToResolvePath = _c.onRequestToResolvePath;
    var remove = useCallback(function (index) {
        setRemovePopoverOpen(false);
        dmnEditorStoreApi.setState(function (state) {
            var externalModelTypesByNamespace = state
                .computed(state)
                .getExternalModelTypesByNamespace(externalModelsByNamespace);
            deleteImport({
                definitions: state.dmn.model.definitions,
                __readonly_index: index,
                __readonly_externalModelTypesByNamespace: externalModelTypesByNamespace,
            });
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace]);
    var rename = useCallback(function (newName) {
        dmnEditorStoreApi.setState(function (state) {
            renameImport({
                definitions: state.dmn.model.definitions,
                index: index,
                newName: newName,
                allTopLevelDataTypesByFeelName: state.computed(state).getDataTypes(externalModelsByNamespace)
                    .allTopLevelDataTypesByFeelName,
            });
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace, index]);
    var extension = useMemo(function () {
        if (allDmnImportNamespaces.has(_import["@_importType"])) {
            return "dmn";
        }
        else if (allPmmlImportNamespaces.has(_import["@_importType"])) {
            return "pmml";
        }
        else {
            return "Unknwon";
        }
    }, [_import]);
    var title = useMemo(function () {
        if (externalModel === undefined) {
            return "";
        }
        if (externalModel.type === "dmn") {
            return externalModel.model.definitions["@_name"];
        }
        else if (externalModel.type === "pmml") {
            return "";
        }
    }, [externalModel]);
    var pathDisplayed = useMemo(function () {
        var _a;
        if (externalModel !== undefined) {
            return ((_a = onRequestToResolvePath === null || onRequestToResolvePath === void 0 ? void 0 : onRequestToResolvePath(externalModel.normalizedPosixPathRelativeToTheOpenFile)) !== null && _a !== void 0 ? _a : externalModel.normalizedPosixPathRelativeToTheOpenFile);
        }
    }, [onRequestToResolvePath, externalModel]);
    var _d = __read(useState(false), 2), isRemovePopoverOpen = _d[0], setRemovePopoverOpen = _d[1];
    var _e = __read(useState(false), 2), isConfirmationPopoverOpen = _e[0], setConfirmationPopoverOpen = _e[1];
    var shouldRenderConfirmationMessage = useMemo(function () { return isRemovePopoverOpen && isConfirmationPopoverOpen; }, [isConfirmationPopoverOpen, isRemovePopoverOpen]);
    return (_jsxs(Card, __assign({ isHoverable: true, isCompact: false }, { children: [_jsxs(CardHeader, { children: [_jsx(CardActions, { children: _jsx(Popover, __assign({ bodyContent: shouldRenderConfirmationMessage ? (_jsxs(Alert, __assign({ isInline: true, variant: AlertVariant.warning, title: "This action have major impact to your model", actionClose: _jsx(AlertActionCloseButton, { onClose: function () {
                                        setRemovePopoverOpen(false);
                                        setConfirmationPopoverOpen(false);
                                    } }), actionLinks: _jsx(_Fragment, { children: _jsx(AlertActionLink, __assign({ onClick: function (ev) {
                                            remove(index);
                                            ev.stopPropagation();
                                            ev.preventDefault();
                                        }, variant: "link", style: { color: "var(--pf-global--danger-color--200)", fontWeight: "bold" } }, { children: "Yes, remove included ".concat(extension.toUpperCase()) })) }) }, { children: [extension === "dmn" && (_jsx(_Fragment, { children: "Removing an included DMN will erase all its imported nodes and connected edges from your model. The references to item definitions, Business Knowledge Model functions, and Decision expressions will remain, requiring to be manually removed." })), extension === "pmml" && (_jsx(_Fragment, { children: "Removing an included PMML will not erase references on Boxed Function expressions, requiring it to be manually removed." }))] }))) : (_jsxs(Button, __assign({ variant: "plain", onClick: function (ev) {
                                    ev.stopPropagation();
                                    ev.preventDefault();
                                    if (isReadonly) {
                                        return;
                                    }
                                    setConfirmationPopoverOpen(true);
                                } }, { children: [_jsx(TrashIcon, {}), "  ", "Remove"] }))), hasNoPadding: shouldRenderConfirmationMessage, maxWidth: shouldRenderConfirmationMessage ? "300px" : "150px", minWidth: shouldRenderConfirmationMessage ? "300px" : "150px", isVisible: isRemovePopoverOpen, showClose: false, shouldClose: function () {
                                setRemovePopoverOpen(false);
                                setConfirmationPopoverOpen(false);
                            }, position: PopoverPosition.bottom, shouldOpen: function () { return setRemovePopoverOpen(true); } }, { children: _jsx(Button, __assign({ variant: "plain", onClick: function (ev) {
                                    ev.stopPropagation();
                                    ev.preventDefault();
                                } }, { children: _jsx(KebabToggle, {}) })) })) }), _jsxs(CardTitle, { children: [_jsx(InlineFeelNameInput, { placeholder: EMPTY_IMPORT_NAME_NAMESPACE_IDENTIFIER, isPlain: true, allUniqueNames: useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []), id: _import["@_id"], name: _import["@_name"], isReadonly: false, shouldCommitOnBlur: true, onRenamed: rename, validate: DMN15_SPEC.IMPORT.name.isValid }), _jsx("br", {}), _jsx("br", {}), _jsx(ExternalModelLabel, { extension: extension }), _jsx("br", {}), _jsx("br", {})] })] }), externalModel ? (_jsxs(CardBody, { children: ["".concat(title), _jsx("br", {}), _jsx("br", {}), _jsx("small", { children: _jsx(Button, __assign({ variant: ButtonVariant.link, style: { paddingLeft: 0, whiteSpace: "break-spaces", textAlign: "left" }, onClick: function () {
                                onRequestToJumpToPath === null || onRequestToJumpToPath === void 0 ? void 0 : onRequestToJumpToPath(externalModel.normalizedPosixPathRelativeToTheOpenFile);
                            } }, { children: _jsx("i", { children: pathDisplayed }) })) })] })) : (_jsx(CardBody, { children: _jsxs(Alert, __assign({ title: "External model not found.", isInline: true, variant: AlertVariant.danger }, { children: [_jsx(Divider, { style: { marginTop: "16px" } }), _jsx("br", {}), _jsxs("p", { children: [_jsx("b", { children: "Namespace:" }), "\u00A0", _import["@_namespace"]] }), _jsxs("p", { children: [_jsx("b", { children: "URI:" }), "\u00A0", (_b = _import["@_locationURI"]) !== null && _b !== void 0 ? _b : _jsx("i", { children: "None" })] })] })) }))] })));
}
//# sourceMappingURL=IncludedModels.js.map