var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useState } from "react";
import { DiagramLhsPanel, DmnEditorTab } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { buildXmlHref } from "../xml/xmlHrefs";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStatePrimary, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { CubesIcon } from "@patternfly/react-icons/dist/js/icons/cubes-icon";
import { DmnObjectListItem } from "./DmnObjectListItem";
import { Text, TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { EMPTY_IMPORT_NAME_NAMESPACE_IDENTIFIER } from "../includedModels/IncludedModels";
import { useDmnEditor } from "../DmnEditorContext";
import { SearchInput } from "@patternfly/react-core/dist/js/components/SearchInput";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export var MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS = "kie-dmn-editor--external-node-from-included-models";
export function ExternalNodesPanel() {
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var importsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).importsByNamespace(); });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var externalDmnsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).getExternalModelTypesByNamespace(externalModelsByNamespace).dmns; });
    var dmnShapesByHref = useDmnEditorStore(function (s) { return s.computed(s).indexedDrd().dmnShapesByHref; });
    var onRequestToResolvePath = useDmnEditor().onRequestToResolvePath;
    var onDragStart = useCallback(function (event, externalNode) {
        event.dataTransfer.setData(MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS, JSON.stringify(externalNode));
        event.dataTransfer.effectAllowed = "move";
    }, []);
    var _a = __read(useState(""), 2), filter = _a[0], setFilter = _a[1];
    return (_jsxs(_Fragment, { children: [externalDmnsByNamespace.size === 0 && (_jsx(_Fragment, { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, __assign({ size: "md", headingLevel: "h4" }, { children: "No external nodes available" })), _jsx(EmptyStateBody, { children: "Maybe the included models have no exported nodes, or there are no included models." }), _jsx("br", {}), _jsx(EmptyStatePrimary, { children: _jsx(Button, __assign({ variant: ButtonVariant.link, onClick: function () {
                                    return dmnEditorStoreApi.setState(function (state) {
                                        state.navigation.tab = DmnEditorTab.INCLUDED_MODELS;
                                    });
                                } }, { children: "Include model..." })) })] }) })), externalDmnsByNamespace.size > 0 && (_jsxs(_Fragment, { children: [_jsxs("div", __assign({ className: "kie-dmn-editor--sticky-top-glass-header", style: { padding: "12px" } }, { children: [_jsxs(Flex, __assign({ justifyContent: { default: "justifyContentSpaceBetween" } }, { children: [_jsx(TextContent, { children: _jsx(Text, __assign({ component: "h3" }, { children: "External nodes" })) }), _jsx(Button, __assign({ title: "Close", variant: ButtonVariant.plain, onClick: function () {
                                            return dmnEditorStoreApi.setState(function (state) {
                                                state.diagram.openLhsPanel = DiagramLhsPanel.NONE;
                                            });
                                        } }, { children: _jsx(TimesIcon, {}) }))] })), _jsx(Divider, { style: { marginBottom: "12px" } }), _jsx(SearchInput, { style: { marginBottom: "12px", height: "36px" }, onKeyDown: function (e) { return e.stopPropagation(); }, autoFocus: true, placeholder: "Filter...", value: filter, onChange: function (_event, value) { return setFilter(value); }, onClear: function () { return setFilter(""); } })] })), _jsx("div", __assign({ style: { padding: "12px" } }, { children: __spreadArray([], __read(externalDmnsByNamespace.entries()), false).flatMap(function (_a) {
                            var _b, _c, _d, _e;
                            var _f = __read(_a, 2), namespace = _f[0], externalDmn = _f[1];
                            var externalDmnDefinitions = externalDmn.model.definitions;
                            var _import = importsByNamespace.get(namespace);
                            if (!_import) {
                                console.debug("DMN EDITOR: Couldn't find import for namespace '".concat(namespace, "', although there's an external DMN referncing it."));
                                return [];
                            }
                            var nodes = (_b = externalDmnDefinitions.drgElement) === null || _b === void 0 ? void 0 : _b.filter(function (drgElement) { return drgElement["@_name"].toLowerCase().includes(filter.toLowerCase()); }).map(function (drgElement) {
                                var dmnObjectHref = buildXmlHref({ namespace: namespace, id: drgElement["@_id"] });
                                var isAlreadyIncluded = dmnShapesByHref.has(dmnObjectHref);
                                return (_jsx("div", __assign({ className: "kie-dmn-editor--external-nodes-list-item", draggable: !isAlreadyIncluded, style: { opacity: isAlreadyIncluded ? "0.4" : undefined }, onDragStart: function (event) {
                                        return onDragStart(event, {
                                            externalDrgElementNamespace: namespace,
                                            externalDrgElementId: drgElement["@_id"],
                                        });
                                    } }, { children: _jsx(Flex, __assign({ alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentFlexStart" }, spaceItems: { default: "spaceItemsNone" } }, { children: _jsx(DmnObjectListItem, { dmnObjectHref: dmnObjectHref, dmnObject: drgElement, namespace: namespace, relativeToNamespace: namespace }) })) }), drgElement["@_id"]));
                            });
                            if (((_c = nodes === null || nodes === void 0 ? void 0 : nodes.length) !== null && _c !== void 0 ? _c : 0) <= 0) {
                                return [];
                            }
                            return (_jsxs("div", __assign({ className: "kie-dmn-editor--external-nodes-section" }, { children: [_jsxs("div", __assign({ className: "kie-dmn-editor--external-nodes-section-title" }, { children: [_jsx("b", { children: "".concat(externalDmnDefinitions["@_name"]) }), " ", "(", _import["@_name"] || _jsx("i", __assign({ style: { color: "gray" } }, { children: EMPTY_IMPORT_NAME_NAMESPACE_IDENTIFIER })), ")", _jsx("br", {}), _jsx("small", { children: _jsx("i", { children: (_e = (_d = onRequestToResolvePath === null || onRequestToResolvePath === void 0 ? void 0 : onRequestToResolvePath(externalDmn.normalizedPosixPathRelativeToTheOpenFile)) !== null && _d !== void 0 ? _d : externalDmn.normalizedPosixPathRelativeToTheOpenFile) !== null && _e !== void 0 ? _e : "" }) })] })), nodes] }), externalDmnDefinitions["@_id"]));
                        }) }))] }))] }));
}
//# sourceMappingURL=ExternalNodesPanel.js.map