var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { Fragment as _Fragment, jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { TypeRefLabel } from "../dataTypes/TypeRefLabel";
import { NodeIcon } from "../icons/Icons";
import { getNodeTypeFromDmnObject } from "../diagram/maths/DmnMaths";
import { buildFeelQNameFromNamespace } from "../feel/buildFeelQName";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { DmnBuiltInDataType, generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { useDmnEditorStore } from "../store/StoreContext";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
export function DmnObjectListItem(_a) {
    var _b, _c, _d, _e;
    var dmnObject = _a.dmnObject, dmnObjectHref = _a.dmnObjectHref, namespace = _a.namespace, relativeToNamespace = _a.relativeToNamespace;
    var importsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).importsByNamespace(); });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var allTopLevelDataTypesByFeelName = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelDataTypesByFeelName; });
    var isAlternativeInputDataShape = useDmnEditorStore(function (s) { return s.computed(s).isAlternativeInputDataShape(); });
    var displayName = dmnObject
        ? buildFeelQNameFromNamespace({
            namedElement: dmnObject,
            importsByNamespace: importsByNamespace,
            namespace: namespace,
            relativeToNamespace: relativeToNamespace,
        }).full
        : dmnObjectHref;
    var isValid = useDmnEditorStore(function (s) {
        var _a;
        return DMN15_SPEC.namedElement.isValidName((_a = dmnObject === null || dmnObject === void 0 ? void 0 : dmnObject["@_id"]) !== null && _a !== void 0 ? _a : generateUuid(), displayName, s.computed(s).getAllFeelVariableUniqueNames());
    });
    var Icon = useMemo(function () {
        if (dmnObject === undefined) {
            throw new Error("Icon can't be defined without a DMN object");
        }
        var nodeType = getNodeTypeFromDmnObject(dmnObject);
        if (nodeType === undefined) {
            throw new Error("Can't determine node icon with undefined node type");
        }
        return NodeIcon({ nodeType: nodeType, isAlternativeInputDataShape: isAlternativeInputDataShape });
    }, [dmnObject, isAlternativeInputDataShape]);
    return !dmnObject ? (_jsx(_Fragment, { children: dmnObjectHref })) : (_jsxs(Flex, __assign({ alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentFlexStart" }, spaceItems: { default: "spaceItemsNone" } }, { children: [_jsx("div", __assign({ style: { width: "40px", height: "40px", marginRight: 0 } }, { children: _jsx(Icon, {}) })), _jsx("div", __assign({ style: { color: isValid ? undefined : "red" } }, { children: "".concat(displayName) })), _jsx("div", { children: dmnObject.__$$element !== "knowledgeSource" ? (_jsxs(_Fragment, { children: ["\u00A0", _jsx(TypeRefLabel, { typeRef: (_b = dmnObject.variable) === null || _b === void 0 ? void 0 : _b["@_typeRef"], relativeToNamespace: namespace, isCollection: (_e = allTopLevelDataTypesByFeelName.get((_d = (_c = dmnObject.variable) === null || _c === void 0 ? void 0 : _c["@_typeRef"]) !== null && _d !== void 0 ? _d : DmnBuiltInDataType.Undefined)) === null || _e === void 0 ? void 0 : _e.itemDefinition["@_isCollection"] })] })) : (_jsx(_Fragment, {})) })] })));
}
//# sourceMappingURL=DmnObjectListItem.js.map