var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import * as RF from "reactflow";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { AssociationPath, AuthorityRequirementPath, InformationRequirementPath, KnowledgeRequirementPath, } from "../edges/Edges";
import { InputDataNodeSvg, DecisionNodeSvg, BkmNodeSvg, DecisionServiceNodeSvg, KnowledgeSourceNodeSvg, TextAnnotationNodeSvg, GroupNodeSvg, } from "./NodeSvgs";
import { NODE_TYPES } from "./NodeTypes";
import { EDGE_TYPES } from "../edges/EdgeTypes";
var handleButtonSize = 34;
var svgViewboxPadding = Math.sqrt(Math.pow(handleButtonSize, 2) / 2) - handleButtonSize / 2;
var edgeSvgViewboxSize = 25;
var nodeSvgProps = { width: 100, height: 70, x: 0, y: 15, strokeWidth: 8 };
var nodeSvgViewboxSize = nodeSvgProps.width;
export var handleStyle = {
    display: "flex",
    position: "unset",
    transform: "unset",
};
export function OutgoingStuffNodePanel(props) {
    var style = React.useMemo(function () { return ({
        visibility: props.isVisible ? undefined : "hidden",
    }); }, [props.isVisible]);
    var getEdgeActionTitle = React.useCallback(function (edgeType) {
        switch (edgeType) {
            case EDGE_TYPES.informationRequirement: {
                return "Add Information Requirement edge";
            }
            case EDGE_TYPES.knowledgeRequirement: {
                return "Add Knowledge Requirement edge";
            }
            case EDGE_TYPES.authorityRequirement: {
                return "Add Authority Requirement edge";
            }
            case EDGE_TYPES.association: {
                return "Add Association edge";
            }
            default: {
                throw new Error("Add Unknown edge type");
            }
        }
    }, []);
    var getNodeActionTitle = React.useCallback(function (nodeType) {
        switch (nodeType) {
            case NODE_TYPES.decision: {
                return "Add Decision node";
            }
            case NODE_TYPES.bkm: {
                return "Add BKM node";
            }
            case NODE_TYPES.knowledgeSource: {
                return "Add Knowledge Source node";
            }
            case NODE_TYPES.textAnnotation: {
                return "Add Text Annotation node";
            }
            default: {
                throw new Error("Add Unknown node type");
            }
        }
    }, []);
    return (_jsx(_Fragment, { children: _jsxs(Flex, __assign({ className: "kie-dmn-editor--outgoing-stuff-node-panel", style: style }, { children: [props.edgeTypes.length > 0 && (_jsx(FlexItem, { children: props.edgeTypes.map(function (edgeType) { return (_jsx(RF.Handle, __assign({ id: edgeType, isConnectableEnd: false, type: "source", style: handleStyle, position: RF.Position.Top, title: getEdgeActionTitle(edgeType), "data-testid": "".concat(props.nodeHref, "-add-").concat(edgeType) }, { children: _jsxs("svg", __assign({ className: "kie-dmn-editor--round-svg-container", viewBox: "0 0 ".concat(edgeSvgViewboxSize, " ").concat(edgeSvgViewboxSize), style: { padding: "".concat(svgViewboxPadding, "px") } }, { children: [edgeType === EDGE_TYPES.informationRequirement && (_jsx(InformationRequirementPath, { d: "M2,".concat(edgeSvgViewboxSize - 2, " L").concat(edgeSvgViewboxSize - 2, ",0") })), edgeType === EDGE_TYPES.knowledgeRequirement && (_jsx(KnowledgeRequirementPath, { d: "M2,".concat(edgeSvgViewboxSize - 2, " L").concat(edgeSvgViewboxSize - 2, ",0") })), edgeType === EDGE_TYPES.authorityRequirement && (_jsx(AuthorityRequirementPath, { d: "M2,".concat(edgeSvgViewboxSize - 2, " L").concat(edgeSvgViewboxSize - 2, ",2"), centerToConnectionPoint: false })), edgeType === EDGE_TYPES.association && (_jsx(AssociationPath, { d: "M2,".concat(edgeSvgViewboxSize - 2, " L").concat(edgeSvgViewboxSize, ",0"), strokeWidth: 2 }))] })) }), edgeType)); }) })), props.nodeTypes.length > 0 && (_jsx(FlexItem, { children: props.nodeTypes.map(function (nodeType) { return (_jsx(RF.Handle, __assign({ id: nodeType, isConnectableEnd: false, type: "source", style: handleStyle, position: RF.Position.Top, title: getNodeActionTitle(nodeType), "data-testid": "".concat(props.nodeHref, "-add-").concat(nodeType) }, { children: _jsxs("svg", __assign({ className: "kie-dmn-editor--round-svg-container", viewBox: "0 0 ".concat(nodeSvgViewboxSize, " ").concat(nodeSvgViewboxSize), style: { padding: "".concat(svgViewboxPadding, "px") } }, { children: [nodeType === NODE_TYPES.inputData && _jsx(InputDataNodeSvg, __assign({}, nodeSvgProps, { isCollection: false })), nodeType === NODE_TYPES.decision && (_jsx(DecisionNodeSvg, __assign({}, nodeSvgProps, { isCollection: false, hasHiddenRequirements: false }))), nodeType === NODE_TYPES.bkm && _jsx(BkmNodeSvg, __assign({}, nodeSvgProps, { hasHiddenRequirements: false })), nodeType === NODE_TYPES.decisionService && (_jsx(DecisionServiceNodeSvg, __assign({}, nodeSvgProps, { y: 0, height: nodeSvgProps.width, showSectionLabels: true, isReadonly: true }))), nodeType === NODE_TYPES.knowledgeSource && (_jsx(KnowledgeSourceNodeSvg, __assign({}, nodeSvgProps, { hasHiddenRequirements: false }))), nodeType === NODE_TYPES.textAnnotation && _jsx(TextAnnotationNodeSvg, __assign({}, nodeSvgProps)), nodeType === NODE_TYPES.group && _jsx(GroupNodeSvg, __assign({}, nodeSvgProps))] })) }), nodeType)); }) }))] })) }));
}
//# sourceMappingURL=OutgoingStuffNodePanel.js.map