var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useDmnEditorStore } from "../../store/StoreContext";
import { TypeRefSelector } from "../../dataTypes/TypeRefSelector";
import { useDmnEditor } from "../../DmnEditorContext";
import { useResolvedTypeRef } from "../../dataTypes/useResolvedTypeRef";
function stopPropagation(e) {
    e.stopPropagation();
}
export function DataTypeNodePanel(props) {
    var _a;
    var enableDataTypesToolbarOnNodes = useDmnEditorStore(function (s) { return s.diagram.overlays.enableDataTypesToolbarOnNodes; });
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var resolvedTypeRef = useResolvedTypeRef((_a = props.variable) === null || _a === void 0 ? void 0 : _a["@_typeRef"], props.dmnObjectNamespace);
    var isExternalNode = !!props.dmnObjectNamespace;
    return (_jsx(_Fragment, { children: props.isVisible && enableDataTypesToolbarOnNodes && (_jsx("div", __assign({ className: "kie-dmn-editor--data-type-node-panel", onMouseDownCapture: stopPropagation, onKeyDownCapture: stopPropagation, onClick: stopPropagation, onDoubleClick: stopPropagation, onMouseLeave: stopPropagation }, { children: _jsx("div", __assign({ style: { background: isExternalNode ? "rgb(240, 240, 240)" : undefined } }, { children: _jsx(TypeRefSelector, { zoom: 0.8, heightRef: dmnEditorRootElementRef, typeRef: resolvedTypeRef, onChange: props.onChange, onCreate: props.onCreate, onToggle: props.onToggle, menuAppendTo: "parent", isDisabled: isExternalNode }) })) }))) }));
}
//# sourceMappingURL=DataTypeNodePanel.js.map