var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { snapPoint } from "../SnapGrid";
import { EDGE_TYPES } from "../edges/EdgeTypes";
import { AssociationPath, AuthorityRequirementPath, InformationRequirementPath, KnowledgeRequirementPath, } from "../edges/Edges";
import { NODE_TYPES } from "../nodes/NodeTypes";
import { getPositionalHandlePosition } from "../maths/Maths";
import { DecisionNodeSvg, BkmNodeSvg, KnowledgeSourceNodeSvg, TextAnnotationNodeSvg } from "../nodes/NodeSvgs";
import { pointsToPath } from "../maths/DmnMaths";
import { getBoundsCenterPoint } from "../maths/Maths";
import { getDefaultEdgeTypeBetween } from "./graphStructure";
import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { DEFAULT_NODE_SIZES } from "../nodes/DefaultSizes";
import { useDmnEditorStore } from "../../store/StoreContext";
import { useKieEdgePath } from "../edges/useKieEdgePath";
import { PositionalNodeHandleId } from "./PositionalNodeHandles";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
export function ConnectionLine(_a) {
    var _b;
    var _c, _d, _e;
    var toX = _a.toX, toY = _a.toY, fromNode = _a.fromNode, fromHandle = _a.fromHandle;
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var edgeBeingUpdated = useDmnEditorStore(function (s) {
        return s.diagram.edgeIdBeingUpdated
            ? s.computed(s).getDiagramData(externalModelsByNamespace).edgesById.get(s.diagram.edgeIdBeingUpdated)
            : undefined;
    });
    var kieEdgePath = useKieEdgePath(edgeBeingUpdated === null || edgeBeingUpdated === void 0 ? void 0 : edgeBeingUpdated.source, edgeBeingUpdated === null || edgeBeingUpdated === void 0 ? void 0 : edgeBeingUpdated.target, edgeBeingUpdated === null || edgeBeingUpdated === void 0 ? void 0 : edgeBeingUpdated.data);
    var isAlternativeInputDataShape = useDmnEditorStore(function (s) { return s.computed(s).isAlternativeInputDataShape(); });
    var isUpdatingFromSourceHandle = Object.keys(PositionalNodeHandleId).some(function (k) { return PositionalNodeHandleId[k] === (fromHandle === null || fromHandle === void 0 ? void 0 : fromHandle.id); });
    var _f = getBoundsCenterPoint({
        x: (_c = fromNode === null || fromNode === void 0 ? void 0 : fromNode.positionAbsolute) === null || _c === void 0 ? void 0 : _c.x,
        y: (_d = fromNode === null || fromNode === void 0 ? void 0 : fromNode.positionAbsolute) === null || _d === void 0 ? void 0 : _d.y,
        width: fromNode === null || fromNode === void 0 ? void 0 : fromNode.width,
        height: fromNode === null || fromNode === void 0 ? void 0 : fromNode.height,
    }), fromX = _f["@_x"], fromY = _f["@_y"];
    var connectionLinePath = edgeBeingUpdated && kieEdgePath.points
        ? isUpdatingFromSourceHandle
            ? pointsToPath(__spreadArray([{ "@_x": toX, "@_y": toY }], __read(kieEdgePath.points.slice(1)), false))
            : pointsToPath(__spreadArray(__spreadArray([], __read(kieEdgePath.points.slice(0, -1)), false), [{ "@_x": toX, "@_y": toY }], false))
        : "M".concat(fromX, ",").concat(fromY, " L").concat(toX, ",").concat(toY);
    var handleId = isUpdatingFromSourceHandle ? edgeBeingUpdated === null || edgeBeingUpdated === void 0 ? void 0 : edgeBeingUpdated.type : (_e = edgeBeingUpdated === null || edgeBeingUpdated === void 0 ? void 0 : edgeBeingUpdated.type) !== null && _e !== void 0 ? _e : fromHandle === null || fromHandle === void 0 ? void 0 : fromHandle.id;
    if (handleId === EDGE_TYPES.informationRequirement) {
        return _jsx(InformationRequirementPath, { d: connectionLinePath });
    }
    else if (handleId === EDGE_TYPES.knowledgeRequirement) {
        return _jsx(KnowledgeRequirementPath, { d: connectionLinePath });
    }
    else if (handleId === EDGE_TYPES.authorityRequirement) {
        return _jsx(AuthorityRequirementPath, { d: connectionLinePath, centerToConnectionPoint: true });
    }
    else if (handleId === EDGE_TYPES.association) {
        return _jsx(AssociationPath, { d: connectionLinePath });
    }
    else {
        var nodeType = handleId;
        var _g = snapPoint(snapGrid, { "@_x": toX, "@_y": toY }), toXsnapped = _g["@_x"], toYsnapped = _g["@_y"];
        var defaultSize = DEFAULT_NODE_SIZES[nodeType]({ snapGrid: snapGrid, isAlternativeInputDataShape: isAlternativeInputDataShape });
        var _h = __read(getPositionalHandlePosition({ x: toXsnapped, y: toYsnapped, width: defaultSize["@_width"], height: defaultSize["@_height"] }, { x: fromX, y: fromY, width: 1, height: 1 }), 2), toXauto = _h[0], toYauto = _h[1];
        var edgeType = getDefaultEdgeTypeBetween(fromNode === null || fromNode === void 0 ? void 0 : fromNode.type, handleId);
        if (!edgeType) {
            throw new Error("Invalid structure: ".concat(fromNode === null || fromNode === void 0 ? void 0 : fromNode.type, " --(any)--> ").concat(handleId));
        }
        var path = "M".concat(fromX, ",").concat(fromY, " L").concat(toXauto, ",").concat(toYauto);
        var edgeSvg = switchExpression(edgeType, (_b = {},
            _b[EDGE_TYPES.informationRequirement] = _jsx(InformationRequirementPath, { d: path }),
            _b[EDGE_TYPES.knowledgeRequirement] = _jsx(KnowledgeRequirementPath, { d: path }),
            _b[EDGE_TYPES.authorityRequirement] = _jsx(AuthorityRequirementPath, { d: path, centerToConnectionPoint: false }),
            _b[EDGE_TYPES.association] = _jsx(AssociationPath, { d: path }),
            _b));
        if (nodeType === NODE_TYPES.decision) {
            return (_jsxs("g", { children: [edgeSvg, _jsx(DecisionNodeSvg, { x: toXsnapped, y: toYsnapped, width: defaultSize["@_width"], height: defaultSize["@_height"], isCollection: false, hasHiddenRequirements: false })] }));
        }
        else if (nodeType === NODE_TYPES.bkm) {
            return (_jsxs("g", __assign({ className: "pulse" }, { children: [edgeSvg, _jsx(BkmNodeSvg, { x: toXsnapped, y: toYsnapped, width: defaultSize["@_width"], height: defaultSize["@_height"], hasHiddenRequirements: false })] })));
        }
        else if (nodeType === NODE_TYPES.knowledgeSource) {
            return (_jsxs("g", { children: [edgeSvg, _jsx(KnowledgeSourceNodeSvg, { x: toXsnapped, y: toYsnapped, width: defaultSize["@_width"], height: defaultSize["@_height"], hasHiddenRequirements: false })] }));
        }
        else if (nodeType === NODE_TYPES.textAnnotation) {
            return (_jsxs("g", { children: [edgeSvg, _jsx(TextAnnotationNodeSvg, { x: toXsnapped, y: toYsnapped, width: defaultSize["@_width"], height: defaultSize["@_height"] })] }));
        }
    }
    throw new Error("Unknown source of ConnectionLine '".concat(handleId, "'."));
}
//# sourceMappingURL=ConnectionLine.js.map